/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.classindex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ClassIndex {
    public static final String SUBCLASS_INDEX_PREFIX = "META-INF/services/";
    public static final String ANNOTATED_INDEX_PREFIX = "META-INF/annotations/";
    public static final String PACKAGE_INDEX_NAME = "jaxb.index";
    public static final String JAVADOC_PREFIX = "META-INF/javadocs/";

    private ClassIndex() {
    }

    public static <T> List<Class<? extends T>> getSubclasses(Class<T> superClass) {
        return ClassIndex.getSubclasses(superClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T> List<Class<? extends T>> getSubclasses(Class<T> superClass, ClassLoader classLoader) {
        List<String> entries = ClassIndex.getSubclassesNames(superClass, classLoader);
        return ClassIndex.findClasses(classLoader, entries).stream().filter(superClass::isAssignableFrom).map(klass -> klass).collect(Collectors.toList());
    }

    public static <T> List<String> getSubclassesNames(Class<T> superClass) {
        return ClassIndex.getSubclassesNames(superClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T> List<String> getSubclassesNames(Class<T> superClass, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, SUBCLASS_INDEX_PREFIX + superClass.getCanonicalName());
    }

    public static List<Class<?>> getPackageClasses(String packageName) {
        return ClassIndex.getPackageClasses(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static List<Class<?>> getPackageClasses(String packageName, ClassLoader classLoader) {
        List<String> entries = ClassIndex.readIndexFile(classLoader, packageName.replace(".", "/") + "/jaxb.index");
        Set<Class<?>> classes = ClassIndex.findClassesInPackage(classLoader, packageName, entries);
        classes.addAll(ClassIndex.findClasses(classLoader, entries));
        return new ArrayList(classes);
    }

    public static List<String> getPackageClassesNames(String packageName) {
        return ClassIndex.getPackageClassesNames(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static List<String> getPackageClassesNames(String packageName, ClassLoader classLoader) {
        List<String> entries = ClassIndex.readIndexFile(classLoader, packageName.replace(".", "/") + "/jaxb.index");
        return entries.stream().map(simpleName -> packageName + "." + simpleName).collect(Collectors.toList());
    }

    public static List<Class<?>> getAnnotated(Class<? extends Annotation> annotation) {
        return ClassIndex.getAnnotated(annotation, Thread.currentThread().getContextClassLoader());
    }

    public static List<Class<?>> getAnnotated(Class<? extends Annotation> annotation, ClassLoader classLoader) {
        List<String> entries = ClassIndex.getAnnotatedNames(annotation, classLoader);
        return new ArrayList(ClassIndex.findClasses(classLoader, entries));
    }

    public static List<String> getAnnotatedNames(Class<? extends Annotation> annotation) {
        return ClassIndex.getAnnotatedNames(annotation, Thread.currentThread().getContextClassLoader());
    }

    public static List<String> getAnnotatedNames(Class<? extends Annotation> annotation, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, ANNOTATED_INDEX_PREFIX + annotation.getCanonicalName());
    }

    public static String getClassSummary(Class<?> klass) {
        return ClassIndex.getClassSummary(klass, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassSummary(Class<?> klass, ClassLoader classLoader) {
        URL resource = classLoader.getResource(JAVADOC_PREFIX + klass.getCanonicalName());
        if (resource == null) {
            return null;
        }
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    int dotIndex = line.indexOf(46);
                    if (dotIndex != -1) {
                        builder.append(line.subSequence(0, dotIndex));
                        String string = builder.toString().trim();
                        return string;
                    }
                    builder.append(line);
                    line = reader.readLine();
                }
                String string = builder.toString().trim();
                return string;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ClassIndex: Cannot read Javadoc index", e);
        }
    }

    private static List<String> readIndexFile(ClassLoader classLoader, String resourceFile) {
        HashSet<String> entries = new HashSet<String>();
        try {
            Enumeration<URL> resources = classLoader.getResources(resourceFile);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                    String line = reader.readLine();
                    while (line != null) {
                        entries.add(line);
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ClassIndex: Cannot read class index", e);
        }
        return new ArrayList<String>(entries);
    }

    @NotNull
    private static Set<Class<?>> findClasses(ClassLoader classLoader, @NotNull List<String> entries) {
        LinkedHashSet foundClasses = new LinkedHashSet();
        for (String entry : entries) {
            try {
                foundClasses.add(Class.forName(entry, false, classLoader));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return foundClasses;
    }

    @NotNull
    private static Set<Class<?>> findClassesInPackage(ClassLoader classLoader, String packageName, @NotNull List<String> entries) {
        LinkedHashSet foundClasses = new LinkedHashSet();
        for (String entry : entries) {
            if (entry.contains(".")) continue;
            String className = packageName + "." + entry;
            try {
                foundClasses.add(Class.forName(className, false, classLoader));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return foundClasses;
    }
}

