package host.anzo.commons.annotations.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author ANZO
 * @since 02.04.2017
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ConfigProperty {
	String name();
	String value() default "";
	String[] values() default "";
	String splitter() default ",";
	long minValue() default Long.MIN_VALUE;
	long maxValue() default Long.MAX_VALUE;
	boolean isMap() default false;
	boolean isLoadFromFile() default true;
}
