package host.anzo.commons.annotations.startup;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;

/**
 * @author ANZO
 * @since 8/19/2021
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Scheduled {
    /**
     * @return period between calls
     */
    long period();

    /**
     * @return period and delay time unit
     */
    TimeUnit timeUnit();

    /**
     * @return {@code true} if need call task after server start before general task schedule, {@code false} otherwise
     */
    boolean runAfterServerStart() default false;
}