package host.anzo.commons.annotations.startup;

import host.anzo.classindex.IndexAnnotated;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author ANZO
 * @since 9/27/2018
 */
@IndexAnnotated
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface StartupRun {
	/** @return startup level after that method must be invoked */
	String after() default "";
	/** @return startup level before that method must be invoked */
	String before() default "";
	/** @return {@code true} if method must be started asynchronously, {@code false} otherwise */
	boolean isAsync() default false;
}