package host.anzo.commons.annotations.startup;

import host.anzo.classindex.IndexAnnotated;
import host.anzo.commons.enums.startup.EShutdownPriority;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author ANZO
 * @since 27.12.2016
 */
@IndexAnnotated
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface StartupComponent {
	/** @return startup component name (must be declared in StartupLevel) **/
	String value();
	/** @return singleton's class list must be loaded before current component initialized **/
	Class<?>[] dependency() default {};
	/** @return shutdown priority **/
	EShutdownPriority shutdownPriority() default EShutdownPriority.ORDINAL;
}