package host.anzo.commons.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for referencing IDA Pro entities (methods, types) via ida:// protocol.
 * <p>
 * When Ctrl+Click is performed on annotation values, it will open the corresponding
 * entity in IDA Pro using the ida:// protocol handler.
 * </p>
 *
 * @author ANZO
 */
@Target({ElementType.METHOD, ElementType.TYPE, ElementType.CONSTRUCTOR})
@Retention(RetentionPolicy.SOURCE)
public @interface IDAReference {
	/**
	 * The name of the type in IDA Pro.
	 * Will be used to construct ida://type=...
	 */
	String type() default "";

	/**
	 * The name of the type in IDA Pro.
	 * Will be used to construct ida://field=...
	 */
	String field() default "";

	/**
	 * The name of the method in IDA Pro.
	 * Will be used to construct ida://method=...
	 */
	String method() default "";

	/**
	 * The pointer/address of the method in IDA Pro (in hex format).
	 * Will be used to construct ida://methodPtr=...
	 */
	long methodPtr() default -1;
}