package host.anzo.commons.annotations.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author ANZO
 * @since 02.04.2017
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ConfigProperty {
	/** @return Property name */
	String name();
	/** @return Property value */
	String value() default "";
	/** @return Property map values */
	String[] values() default "";
	/** @return Splitter character using for array-type properties */
	String splitter() default ",";
	/** @return Numerical property min value */
	long minValue() default Long.MIN_VALUE;
	/** @return Numerical property max value */
	long maxValue() default Long.MAX_VALUE;
	/** @return Is property having map structure */
	boolean isMap() default false;
	/** @return {@code true} if property must be loaded from the file, {@code false} otherwise */
	boolean isLoadFromFile() default true;
	/** @return {@code true} if config value can be reloaded at runtime, {@code false} otherwise */
	boolean isReloadable() default true;
}