/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.config;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.annotations.config.ConfigAfterLoad;
import host.anzo.commons.annotations.config.ConfigComments;
import host.anzo.commons.annotations.config.ConfigFile;
import host.anzo.commons.annotations.config.ConfigProperty;
import host.anzo.commons.annotations.startup.Reloadable;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.config.ConfigTypeCaster;
import host.anzo.commons.interfaces.startup.IReloadable;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Reloadable(name="all", group="config")
@StartupComponent(value="Configure")
public final class ConfigLoader
implements IReloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigLoader.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final Set<String> VAR_NAMES_CACHE = new HashSet<String>();

    public ConfigLoader() {
        this.loadConfigs(false);
        this.cleanupConfigs();
    }

    private void loadConfigs(boolean isReload) {
        for (Class clazz : ClassIndex.getAnnotated(ConfigFile.class)) {
            boolean loadConfig = false;
            ConfigFile annotation = clazz.getAnnotation(ConfigFile.class);
            if (annotation.loadForPackages().length > 0) {
                for (String classPath : annotation.loadForPackages()) {
                    URL url;
                    if (classPath == null || classPath.isBlank() || (url = this.getClass().getClassLoader().getResource(classPath.replace(".", "/"))) == null) continue;
                    loadConfig = true;
                    break;
                }
            } else {
                loadConfig = true;
            }
            if (!loadConfig) continue;
            File file = this.getConfigFilePath(annotation.name()).toFile();
            if (!file.exists() && file.isDirectory()) {
                file.mkdirs();
            }
            if (!file.exists()) {
                this.buildConfig(clazz);
            } else {
                this.updateConfig(clazz);
            }
            this.loadConfig(clazz, isReload);
        }
    }

    private void cleanupConfigs() {
        List configClasses = List.copyOf(ClassIndex.getAnnotated(ConfigFile.class));
        try (Stream<Path> walk = Files.walk(Paths.get(this.getConfigFolder(), "config"), new FileVisitOption[0]);){
            List<Path> configFiles = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x -> x.toString().endsWith(".properties")).toList();
            for (Path configFilePath : configFiles) {
                if (!configClasses.stream().noneMatch(clazz -> {
                    ConfigFile annotation = clazz.getAnnotation(ConfigFile.class);
                    Path filePath = this.getConfigFilePath(annotation.name());
                    try {
                        return Files.isSameFile(configFilePath, filePath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error checking equality for config file " + String.valueOf(configFilePath), e);
                    }
                })) continue;
                if (Desktop.getDesktop().isSupported(Desktop.Action.MOVE_TO_TRASH)) {
                    Desktop.getDesktop().moveToTrash(configFilePath.toFile());
                    log.warn("Moved to trash [{}] config file due config loader didn't exist anymore.", (Object)configFilePath);
                    continue;
                }
                Files.delete(configFilePath);
                log.warn("Removed [{}] config file due config loader didn't exist anymore.", (Object)configFilePath);
            }
        }
        catch (Exception e) {
            log.error("Error while cleanupConfigs()", (Throwable)e);
        }
    }

    private void updateConfig(@NotNull Class<?> clazz) {
        Properties properties = new Properties();
        Path filePath = this.getConfigFilePath(clazz.getAnnotation(ConfigFile.class).name());
        try (InputStream input = Files.newInputStream(filePath, new OpenOption[0]);){
            properties.load(input);
        }
        catch (IOException ex) {
            log.error("Error while calling loadConfig", (Throwable)ex);
        }
        StringBuilder newPropertiesText = new StringBuilder();
        newPropertiesText.append("\n");
        boolean isNewPropertyExists = false;
        for (Field field : clazz.getDeclaredFields()) {
            String propertyValue;
            ConfigProperty annotation = field.getAnnotation(ConfigProperty.class);
            if (annotation == null) {
                log.error("Field [{}] has no @ConfigProperty annotation", (Object)field.getName());
                continue;
            }
            if (!annotation.isLoadFromFile() || (propertyValue = properties.getProperty(annotation.name())) != null || annotation.isMap()) continue;
            isNewPropertyExists = true;
            newPropertiesText.append("\n");
            newPropertiesText.append(this.generateFieldConfig(clazz, field).trim()).append("\n");
            log.warn("Updated '{}' config with new field '{}'", (Object)filePath, (Object)annotation.name());
        }
        if (isNewPropertyExists) {
            try {
                Files.write(filePath, newPropertiesText.toString().getBytes(), StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                log.error("Error while writing config update", (Throwable)e);
            }
        }
    }

    private void buildConfig(@NotNull Class<?> clazz) {
        Path filePath = this.getConfigFilePath(clazz.getAnnotation(ConfigFile.class).name());
        log.info("Generated '{}'", (Object)filePath);
        try {
            Files.deleteIfExists(filePath);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            log.error("Error while buildConfig()", (Throwable)ex);
            return;
        }
        StringBuilder out = new StringBuilder();
        for (Field field : clazz.getDeclaredFields()) {
            String configField = this.generateFieldConfig(clazz, field);
            if (configField == null || configField.isEmpty()) continue;
            out.append(configField).append("\n");
        }
        if (out.toString().trim().isEmpty()) {
            log.warn("No configuration content generated for {}", (Object)clazz.getName());
            return;
        }
        try {
            Files.write(filePath, out.toString().getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException ex) {
            log.error("Error while writing config file: {}", (Object)filePath, (Object)ex);
        }
    }

    @Nullable
    private String generateFieldConfig(@NotNull Class<?> clazz, @NotNull Field field) {
        String varCacheName;
        ConfigComments configComments = field.getAnnotation(ConfigComments.class);
        ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
        if (configProperty == null) {
            throw new RuntimeException("ConfigProperty annotation not found on field: " + field.getName());
        }
        if (!configProperty.isLoadFromFile()) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        if (configComments != null) {
            for (String txt : configComments.comment()) {
                out.append("# ").append(txt).append("\n");
            }
        }
        if (VAR_NAMES_CACHE.contains(varCacheName = clazz.getSimpleName() + "." + configProperty.name())) {
            log.warn("Config property name [{}] already defined in class [{}]!", (Object)configProperty.name(), (Object)clazz.getSimpleName());
        } else {
            VAR_NAMES_CACHE.add(varCacheName);
        }
        if (configProperty.isMap()) {
            for (String value : configProperty.values()) {
                out.append(value).append("\n");
            }
        } else {
            out.append(configProperty.name()).append(" = ").append(configProperty.value()).append("\n");
        }
        return out.toString();
    }

    private void loadConfig(@NotNull Class<?> clazz, boolean isReload) {
        Properties properties = new Properties();
        Path filePath = this.getConfigFilePath(clazz.getAnnotation(ConfigFile.class).name());
        log.info("Loading config file: {}", (Object)filePath);
        try (InputStream input = Files.newInputStream(filePath, new OpenOption[0]);){
            properties.load(input);
        }
        catch (IOException ex) {
            log.error("Error while calling loadConfig", (Throwable)ex);
        }
        try {
            Object configObject = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : clazz.getFields()) {
                ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
                if (configProperty == null || !configProperty.isLoadFromFile() || !configProperty.isReloadable() && isReload) continue;
                if (!Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
                    log.warn("Invalid modifiers for {} (must be static and final)", (Object)field);
                    continue;
                }
                this.setConfigValue(configObject, field, properties, configProperty);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(ConfigAfterLoad.class) || !accessibleObject.trySetAccessible()) continue;
                ((Method)accessibleObject).invoke(configObject, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Error while initializing config object", (Throwable)e);
        }
    }

    private void setConfigValue(Object object, @NotNull Field field, @NotNull Properties properties, @NotNull ConfigProperty annotation) {
        block7: {
            String propertyValue = properties.getProperty(annotation.name(), annotation.value()).trim();
            try {
                if (!field.canAccess(null)) {
                    field.setAccessible(true);
                }
                if (field.getType().isAssignableFrom(Map.class) || field.getType().isAssignableFrom(EnumMap.class)) {
                    Map map = (Map)field.get(object);
                    map.clear();
                    Class keyType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    Class valueType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                    String mapPrefix = annotation.name();
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String name = (String)entry.getKey();
                        if (!name.startsWith(mapPrefix)) continue;
                        Object key = ConfigTypeCaster.cast(keyType, name.replace(mapPrefix + ".", ""));
                        Object value = ConfigTypeCaster.cast(valueType, ((String)entry.getValue()).trim());
                        map.put(key, value);
                    }
                    break block7;
                }
                try {
                    ConfigTypeCaster.cast(object, field, propertyValue, annotation.splitter(), annotation.minValue(), annotation.maxValue());
                }
                catch (Exception e) {
                    log.error("Error while casting property value \"{}\" to field {}", new Object[]{propertyValue, field, e});
                }
            }
            catch (IllegalAccessException e) {
                log.error("Invalid modifiers for field {}", (Object)field);
            }
        }
    }

    @NotNull
    private Path getConfigFilePath(String fileName) {
        String configFolder = this.getConfigFolder();
        if (configFolder != null && !configFolder.isBlank()) {
            return Paths.get(configFolder, fileName);
        }
        return Paths.get(fileName, new String[0]);
    }

    private String getConfigFolder() {
        return System.getProperty("configFolder", "");
    }

    public void reload() {
        this.loadConfigs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ConfigLoader getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ConfigLoader actualValue = new ConfigLoader();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ConfigLoader)($value == instance ? null : $value);
    }
}

