/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.processors;

import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Method;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;

public abstract class CommonProcessor
extends AbstractProcessor {
    protected TreeMaker maker;
    protected Trees trees;
    protected Messager messager;
    protected Names names;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.messager = procEnv.getMessager();
        ProcessingEnvironment unwrappedProcEnv = CommonProcessor.tryUnwrapJetBrainsProcEnv(procEnv);
        if (unwrappedProcEnv instanceof JavacProcessingEnvironment) {
            JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)unwrappedProcEnv;
            this.maker = TreeMaker.instance(javacEnv.getContext());
            this.trees = Trees.instance(javacEnv);
            this.names = Names.instance(javacEnv.getContext());
            this.log("[ExtendedEnumProcessor] Successfully initialized using JavacProcessingEnvironment.");
        } else {
            this.logError("Could not obtain JavacProcessingEnvironment. Annotation processing might not work correctly. Original env: " + procEnv.getClass().getName());
        }
    }

    protected boolean fieldExists(@NotNull JCTree.JCClassDecl classDecl, String fieldName) {
        return classDecl.defs.stream().anyMatch(def -> def instanceof JCTree.JCVariableDecl && ((JCTree.JCVariableDecl)def).getName().contentEquals(fieldName));
    }

    protected boolean methodExists(@NotNull JCTree.JCClassDecl classDecl, String methodName) {
        return classDecl.defs.stream().anyMatch(def -> def instanceof JCTree.JCMethodDecl && ((JCTree.JCMethodDecl)def).getName().contentEquals(methodName));
    }

    protected boolean methodExists(@NotNull JCTree.JCClassDecl classDecl, String methodName, int paramCount) {
        return classDecl.defs.stream().anyMatch(def -> def instanceof JCTree.JCMethodDecl && ((JCTree.JCMethodDecl)def).getName().contentEquals(methodName) && ((List)((JCTree.JCMethodDecl)def).getParameters()).size() == paramCount);
    }

    protected JCTree.JCExpression createQualifiedName(@NotNull String fullName) {
        String[] parts = fullName.split("\\.");
        JCTree.JCExpression expr = this.maker.Ident(this.names.fromString(parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            expr = this.maker.Select(expr, this.names.fromString(parts[i]));
        }
        return expr;
    }

    private static <T> T tryUnwrapJetBrainsProcEnv(T wrapper) {
        T unwrapped = null;
        try {
            Class<?> apiWrappers = wrapper.getClass().getClassLoader().loadClass("org.jetbrains.jps.javac.APIWrappers");
            Method unwrapMethod = apiWrappers.getDeclaredMethod("unwrap", Class.class, Object.class);
            unwrapped = ProcessingEnvironment.class.cast(unwrapMethod.invoke(null, ProcessingEnvironment.class, wrapper));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unwrapped != null ? unwrapped : (T)wrapper;
    }

    protected void log(String msg) {
        if (this.messager != null) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "[" + this.getClass().getSimpleName() + "] " + msg);
        } else {
            System.out.println("NOTE: [" + this.getClass().getSimpleName() + "] " + msg + " (Messager not initialized)");
        }
    }

    protected void logError(String msg) {
        if (this.messager != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[" + this.getClass().getSimpleName() + "] " + msg);
        } else {
            System.err.println("ERROR: [" + this.getClass().getSimpleName() + "] " + msg + " (Messager not initialized)");
        }
    }

    protected void logWarn(String msg) {
        if (this.messager != null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "[" + this.getClass().getSimpleName() + "] " + msg);
        } else {
            System.out.println("WARN: [" + this.getClass().getSimpleName() + "] " + msg + " (Messager not initialized)");
        }
    }
}

