/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.processors;

import com.google.auto.service.AutoService;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import host.anzo.commons.processors.CommonProcessor;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"host.anzo.commons.annotations.processors.ExtendedEnum"})
@AutoService(value={Processor.class})
public class ExtendedEnumProcessor
extends CommonProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.maker == null || this.trees == null || this.names == null) {
            this.logError("Processor essentials not initialized. Skipping processing.");
            return false;
        }
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        TypeElement extendedEnumAnnotation = this.processingEnv.getElementUtils().getTypeElement("host.anzo.commons.annotations.processors.ExtendedEnum");
        if (extendedEnumAnnotation == null) {
            this.logError("Could not resolve host.anzo.commons.annotations.processors.ExtendedEnum annotation.");
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(extendedEnumAnnotation)) {
            if (element.getKind() == ElementKind.ENUM) {
                TreePath path = this.trees.getPath(element);
                if (path == null) {
                    this.logWarn("Could not get TreePath for element: " + String.valueOf(element.getSimpleName()));
                    continue;
                }
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)path.getLeaf();
                this.addCacheListField(classDecl);
                this.addGetValueMethod(classDecl);
                this.addGetValuesMethod(classDecl);
                this.addCacheMapField(classDecl);
                this.addGetValueOfMethodWithTwoParams(classDecl);
                this.addGetValueOfMethodWithOneParam(classDecl);
                continue;
            }
            this.logWarn("@" + String.valueOf(extendedEnumAnnotation.getSimpleName()) + " applied to non-enum: " + String.valueOf(element.getSimpleName()));
        }
        return false;
    }

    private void addCacheListField(JCTree.JCClassDecl classDecl) {
        String fieldName = "cacheList";
        if (this.fieldExists(classDecl, "cacheList")) {
            return;
        }
        JCTree.JCTypeApply listType = this.maker.TypeApply(this.createQualifiedName("java.util.List"), List.of(this.maker.Ident(classDecl.name)));
        JCTree.JCMethodInvocation valuesCall = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(classDecl.name), this.names.fromString("values")), List.nil());
        JCTree.JCMethodInvocation init = this.maker.Apply(List.nil(), this.maker.Select(this.createQualifiedName("java.util.List"), this.names.fromString("of")), List.of(valuesCall));
        JCTree.JCVariableDecl cacheListField = this.maker.VarDef(this.maker.Modifiers(26L), this.names.fromString("cacheList"), listType, init);
        classDecl.defs = classDecl.defs.append(cacheListField);
    }

    private void addGetValueMethod(JCTree.JCClassDecl classDecl) {
        String methodName = "getValue";
        if (this.methodExists(classDecl, "getValue")) {
            return;
        }
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString("getValue"), this.maker.Ident(classDecl.name), List.nil(), List.of(this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("ordinal"), this.maker.TypeIdent(TypeTag.INT), null)), List.nil(), this.maker.Block(0L, List.of(this.maker.Return(this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("cacheList")), this.names.fromString("get")), List.of(this.maker.Ident(this.names.fromString("ordinal"))))))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addGetValuesMethod(JCTree.JCClassDecl classDecl) {
        String methodName = "getValues";
        if (this.methodExists(classDecl, "getValues")) {
            return;
        }
        JCTree.JCTypeApply returnType = this.maker.TypeApply(this.createQualifiedName("java.util.List"), List.of(this.maker.Ident(classDecl.name)));
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString("getValues"), returnType, List.nil(), List.nil(), List.nil(), this.maker.Block(0L, List.of(this.maker.Return(this.maker.Ident(this.names.fromString("cacheList"))))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addCacheMapField(JCTree.JCClassDecl classDecl) {
        String fieldName = "cacheMap";
        if (this.fieldExists(classDecl, "cacheMap")) {
            return;
        }
        JCTree.JCExpression stringType = this.createQualifiedName("java.lang.String");
        JCTree.JCIdent enumType = this.maker.Ident(classDecl.name);
        JCTree.JCTypeApply mapType = this.maker.TypeApply(this.createQualifiedName("java.util.Map"), List.of(stringType, enumType));
        JCTree.JCIdent cacheListExpr = this.maker.Ident(this.names.fromString("cacheList"));
        JCTree.JCFieldAccess streamCall = this.maker.Select((JCTree.JCExpression)cacheListExpr, this.names.fromString("stream"));
        JCTree.JCMethodInvocation streamApply = this.maker.Apply(List.nil(), streamCall, List.nil());
        JCTree.JCVariableDecl paramE1 = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("e"), null, null);
        JCTree.JCFieldAccess eName = this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("e")), this.names.fromString("name"));
        JCTree.JCMethodInvocation nameCall = this.maker.Apply(List.nil(), eName, List.nil());
        JCTree.JCLambda lambda1 = this.maker.Lambda(List.of(paramE1), nameCall);
        JCTree.JCVariableDecl paramE2 = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("e"), null, null);
        JCTree.JCIdent eRef = this.maker.Ident(this.names.fromString("e"));
        JCTree.JCLambda lambda2 = this.maker.Lambda(List.of(paramE2), eRef);
        JCTree.JCFieldAccess collectorsToMap = this.maker.Select(this.createQualifiedName("java.util.stream.Collectors"), this.names.fromString("toMap"));
        JCTree.JCMethodInvocation toMapApply = this.maker.Apply(List.nil(), collectorsToMap, List.of(lambda1, lambda2));
        JCTree.JCMethodInvocation collectCall = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)streamApply, this.names.fromString("collect")), List.of(toMapApply));
        JCTree.JCVariableDecl cacheMapField = this.maker.VarDef(this.maker.Modifiers(26L), this.names.fromString("cacheMap"), mapType, collectCall);
        classDecl.defs = classDecl.defs.append(cacheMapField);
    }

    private void addGetValueOfMethodWithTwoParams(JCTree.JCClassDecl classDecl) {
        String methodName = "getValueOf";
        if (this.methodExists(classDecl, methodName, 2)) {
            return;
        }
        JCTree.JCVariableDecl paramName = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("name"), this.createQualifiedName("java.lang.String"), null);
        JCTree.JCVariableDecl paramDefault = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("defaultValue"), this.maker.Ident(classDecl.name), null);
        List<JCTree.JCVariableDecl> params = List.of(paramName, paramDefault);
        JCTree.JCMethodInvocation getOrDefault = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("cacheMap")), this.names.fromString("getOrDefault")), List.of(this.maker.Ident(this.names.fromString("name")), this.maker.Ident(this.names.fromString("defaultValue"))));
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString(methodName), this.maker.Ident(classDecl.name), List.nil(), params, List.nil(), this.maker.Block(0L, List.of(this.maker.Return(getOrDefault))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addGetValueOfMethodWithOneParam(JCTree.JCClassDecl classDecl) {
        String methodName = "getValueOf";
        if (this.methodExists(classDecl, methodName, 1)) {
            return;
        }
        JCTree.JCVariableDecl paramName = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("name"), this.createQualifiedName("java.lang.String"), null);
        List<JCTree.JCVariableDecl> params = List.of(paramName);
        JCTree.JCMethodInvocation call = this.maker.Apply(List.nil(), this.maker.Ident(this.names.fromString(methodName)), List.of(this.maker.Ident(this.names.fromString("name")), this.maker.Literal(TypeTag.BOT, null)));
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString(methodName), this.maker.Ident(classDecl.name), List.nil(), params, List.nil(), this.maker.Block(0L, List.of(this.maker.Return(call))), null);
        classDecl.defs = classDecl.defs.append(method);
    }
}

