/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.processors;

import com.google.auto.service.AutoService;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import host.anzo.commons.processors.CommonProcessor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jetbrains.annotations.NotNull;

@SupportedAnnotationTypes(value={"host.anzo.commons.annotations.processors.ExtendedEnum"})
@AutoService(value={Processor.class})
public class ExtendedEnumProcessor
extends CommonProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.maker == null || this.trees == null || this.names == null) {
            this.logError("Processor essentials not initialized. Skipping processing.");
            return false;
        }
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        TypeElement extendedEnumAnnotation = this.processingEnv.getElementUtils().getTypeElement("host.anzo.commons.annotations.processors.ExtendedEnum");
        if (extendedEnumAnnotation == null) {
            this.logError("Could not resolve host.anzo.commons.annotations.processors.ExtendedEnum annotation.");
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(extendedEnumAnnotation)) {
            if (element.getKind() == ElementKind.ENUM) {
                TreePath path = this.trees.getPath(element);
                if (path == null) {
                    this.logWarn("Could not get TreePath for element: " + String.valueOf(element.getSimpleName()));
                    continue;
                }
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)path.getLeaf();
                this.addCacheListField(classDecl);
                this.addGetValueByOrdinalMethod(classDecl);
                this.addGetValuesMethod(classDecl);
                this.addDefaultNameCacheMapField(classDecl);
                this.addDefaultGetValueOfMethodWithTwoParams(classDecl);
                this.addDefaultGetValueOfMethodWithOneParam(classDecl);
                Set<String> cacheKeyFieldNames = this.getCacheKeyFieldNames(element);
                List<JCTree.JCStatement> allCustomMapPutStatements = List.nil();
                if (cacheKeyFieldNames.isEmpty()) continue;
                for (String fieldName : cacheKeyFieldNames) {
                    JCTree.JCExpression fieldTypeNode = this.findFieldType(classDecl, fieldName);
                    if (fieldTypeNode == null) {
                        this.logError("Field '" + fieldName + "' specified in @ExtendedEnum cacheKeys not found in enum " + classDecl.name.toString() + ".");
                        continue;
                    }
                    String capitalizedFieldName = this.capitalize(fieldName);
                    String mapFieldName = "cacheMapBy" + capitalizedFieldName;
                    String getterMethodName = "getValueOf" + capitalizedFieldName;
                    if (this.fieldExists(classDecl, mapFieldName) || this.methodExists(classDecl, getterMethodName, 1)) continue;
                    this.addCustomCacheMapFieldDeclaration(classDecl, fieldTypeNode, mapFieldName);
                    JCTree.JCStatement putStatement = this.createCustomCacheMapPutStatement(this.names.fromString("enumConstant"), fieldName, mapFieldName);
                    allCustomMapPutStatements = allCustomMapPutStatements.append(putStatement);
                    this.addCustomValueGetterMethod(classDecl, fieldName, fieldTypeNode, getterMethodName, mapFieldName);
                }
                if (!allCustomMapPutStatements.nonEmpty()) continue;
                JCTree.JCIdent enumIdent = this.maker.Ident(classDecl.name);
                Name loopVarName = this.names.fromString("enumConstant");
                JCTree.JCVariableDecl loopVar = this.maker.VarDef(this.maker.Modifiers(0L), loopVarName, enumIdent, null);
                JCTree.JCMethodInvocation valuesCall = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)enumIdent, this.names.fromString("values")), List.nil());
                JCTree.JCBlock forLoopBody = this.maker.Block(0L, allCustomMapPutStatements);
                JCTree.JCEnhancedForLoop singleForLoop = this.maker.ForeachLoop(loopVar, valuesCall, forLoopBody);
                JCTree.JCBlock combinedStaticInitializer = this.maker.Block(8L, List.of(singleForLoop));
                classDecl.defs = classDecl.defs.append(combinedStaticInitializer);
                continue;
            }
            this.logWarn("@" + String.valueOf(extendedEnumAnnotation.getSimpleName()) + " applied to non-enum: " + String.valueOf(element.getSimpleName()));
        }
        return false;
    }

    @NotNull
    private Set<String> getCacheKeyFieldNames(@NotNull Element element) {
        HashSet<String> keys = new HashSet<String>();
        AnnotationMirror extendedEnumAnnotationMirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("host.anzo.commons.annotations.processors.ExtendedEnum")) continue;
            extendedEnumAnnotationMirror = annotationMirror;
            break;
        }
        if (extendedEnumAnnotationMirror != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = this.processingEnv.getElementUtils().getElementValuesWithDefaults(extendedEnumAnnotationMirror);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("cacheKeys")) continue;
                Object value = entry.getValue().getValue();
                if (!(value instanceof java.util.List)) break;
                for (Object item : (java.util.List)value) {
                    Object innerValue;
                    if (!(item instanceof AnnotationValue) || !((innerValue = ((AnnotationValue)item).getValue()) instanceof String)) continue;
                    keys.add((String)innerValue);
                }
            }
        }
        return keys;
    }

    private void addCacheListField(JCTree.JCClassDecl classDecl) {
        String fieldName = "cacheList";
        if (this.fieldExists(classDecl, "cacheList")) {
            return;
        }
        JCTree.JCTypeApply listType = this.maker.TypeApply(this.createQualifiedName("java.util.List"), List.of(this.maker.Ident(classDecl.name)));
        JCTree.JCMethodInvocation valuesCall = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(classDecl.name), this.names.fromString("values")), List.nil());
        JCTree.JCMethodInvocation init = this.maker.Apply(List.nil(), this.maker.Select(this.createQualifiedName("java.util.List"), this.names.fromString("of")), List.of(valuesCall));
        JCTree.JCVariableDecl cacheListField = this.maker.VarDef(this.maker.Modifiers(26L), this.names.fromString("cacheList"), listType, init);
        classDecl.defs = classDecl.defs.append(cacheListField);
    }

    private void addGetValueByOrdinalMethod(JCTree.JCClassDecl classDecl) {
        String methodName = "getValue";
        if (this.methodExists(classDecl, "getValue", 1)) {
            return;
        }
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString("getValue"), this.maker.Ident(classDecl.name), List.nil(), List.of(this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("ordinal"), this.maker.TypeIdent(TypeTag.INT), null)), List.nil(), this.maker.Block(0L, List.of(this.maker.Return(this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("cacheList")), this.names.fromString("get")), List.of(this.maker.Ident(this.names.fromString("ordinal"))))))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addGetValuesMethod(JCTree.JCClassDecl classDecl) {
        String methodName = "getValues";
        if (this.methodExists(classDecl, "getValues", 0)) {
            return;
        }
        JCTree.JCTypeApply returnType = this.maker.TypeApply(this.createQualifiedName("java.util.List"), List.of(this.maker.Ident(classDecl.name)));
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString("getValues"), returnType, List.nil(), List.nil(), List.nil(), this.maker.Block(0L, List.of(this.maker.Return(this.maker.Ident(this.names.fromString("cacheList"))))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addDefaultNameCacheMapField(JCTree.JCClassDecl classDecl) {
        String fieldName = "cacheMap";
        if (this.fieldExists(classDecl, "cacheMap")) {
            return;
        }
        JCTree.JCExpression stringType = this.createQualifiedName("java.lang.String");
        JCTree.JCIdent enumType = this.maker.Ident(classDecl.name);
        JCTree.JCTypeApply mapType = this.maker.TypeApply(this.createQualifiedName("java.util.Map"), List.of(stringType, enumType));
        JCTree.JCIdent cacheListExpr = this.maker.Ident(this.names.fromString("cacheList"));
        JCTree.JCFieldAccess streamCall = this.maker.Select((JCTree.JCExpression)cacheListExpr, this.names.fromString("stream"));
        JCTree.JCMethodInvocation streamApply = this.maker.Apply(List.nil(), streamCall, List.nil());
        JCTree.JCVariableDecl paramE1 = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("e"), null, null);
        JCTree.JCFieldAccess eName = this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("e")), this.names.fromString("name"));
        JCTree.JCMethodInvocation nameCall = this.maker.Apply(List.nil(), eName, List.nil());
        JCTree.JCLambda lambda1 = this.maker.Lambda(List.of(paramE1), nameCall);
        JCTree.JCVariableDecl paramE2 = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("e"), null, null);
        JCTree.JCIdent eRef = this.maker.Ident(this.names.fromString("e"));
        JCTree.JCLambda lambda2 = this.maker.Lambda(List.of(paramE2), eRef);
        JCTree.JCFieldAccess collectorsToMap = this.maker.Select(this.createQualifiedName("java.util.stream.Collectors"), this.names.fromString("toMap"));
        JCTree.JCMethodInvocation toMapApply = this.maker.Apply(List.nil(), collectorsToMap, List.of(lambda1, lambda2));
        JCTree.JCMethodInvocation collectCall = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)streamApply, this.names.fromString("collect")), List.of(toMapApply));
        JCTree.JCVariableDecl cacheMapField = this.maker.VarDef(this.maker.Modifiers(26L), this.names.fromString("cacheMap"), mapType, collectCall);
        classDecl.defs = classDecl.defs.append(cacheMapField);
    }

    private void addDefaultGetValueOfMethodWithTwoParams(JCTree.JCClassDecl classDecl) {
        String methodName = "getValueOf";
        if (this.methodExists(classDecl, methodName, 2)) {
            return;
        }
        JCTree.JCVariableDecl paramName = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("name"), this.createQualifiedName("java.lang.String"), null);
        JCTree.JCVariableDecl paramDefault = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("defaultValue"), this.maker.Ident(classDecl.name), null);
        List<JCTree.JCVariableDecl> params = List.of(paramName, paramDefault);
        JCTree.JCMethodInvocation getOrDefault = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("cacheMap")), this.names.fromString("getOrDefault")), List.of(this.maker.Ident(this.names.fromString("name")), this.maker.Ident(this.names.fromString("defaultValue"))));
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString(methodName), this.maker.Ident(classDecl.name), List.nil(), params, List.nil(), this.maker.Block(0L, List.of(this.maker.Return(getOrDefault))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addDefaultGetValueOfMethodWithOneParam(JCTree.JCClassDecl classDecl) {
        String methodName = "getValueOf";
        if (this.methodExists(classDecl, methodName, 1)) {
            return;
        }
        JCTree.JCVariableDecl paramName = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("name"), this.createQualifiedName("java.lang.String"), null);
        List<JCTree.JCVariableDecl> params = List.of(paramName);
        JCTree.JCMethodInvocation call = this.maker.Apply(List.nil(), this.maker.Ident(this.names.fromString(methodName)), List.of(this.maker.Ident(this.names.fromString("name")), this.maker.Literal(TypeTag.BOT, null)));
        JCTree.JCMethodDecl method = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString(methodName), this.maker.Ident(classDecl.name), List.nil(), params, List.nil(), this.maker.Block(0L, List.of(this.maker.Return(call))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addCustomCacheMapFieldDeclaration(@NotNull JCTree.JCClassDecl classDecl, JCTree.JCExpression fieldType, String mapFieldName) {
        JCTree.JCIdent enumIdent = this.maker.Ident(classDecl.name);
        JCTree.JCExpression mapKeyType = this.getBoxedType(fieldType);
        JCTree.JCTypeApply mapGenericType = this.maker.TypeApply(this.createQualifiedName("java.util.Map"), List.of(mapKeyType, enumIdent));
        JCTree.JCNewClass newHashMapInstance = this.maker.NewClass(null, List.nil(), this.maker.TypeApply(this.createQualifiedName("java.util.HashMap"), List.nil()), List.nil(), null);
        JCTree.JCVariableDecl cacheMapVDef = this.maker.VarDef(this.maker.Modifiers(26L), this.names.fromString(mapFieldName), mapGenericType, newHashMapInstance);
        classDecl.defs = classDecl.defs.append(cacheMapVDef);
    }

    private JCTree.JCStatement createCustomCacheMapPutStatement(Name loopVarNameIdentifier, String originalFieldName, String mapFieldName) {
        JCTree.JCIdent loopVarAccess = this.maker.Ident(loopVarNameIdentifier);
        JCTree.JCFieldAccess fieldAccessInLoop = this.maker.Select((JCTree.JCExpression)loopVarAccess, this.names.fromString(originalFieldName));
        JCTree.JCMethodInvocation putCall = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString(mapFieldName)), this.names.fromString("put")), List.of(fieldAccessInLoop, loopVarAccess));
        return this.maker.Exec(putCall);
    }

    private void addCustomValueGetterMethod(@NotNull JCTree.JCClassDecl classDecl, String originalFieldName, JCTree.JCExpression fieldType, String methodName, String mapFieldName) {
        JCTree.JCIdent enumIdent = this.maker.Ident(classDecl.name);
        JCTree.JCVariableDecl methodParam = this.maker.VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString(originalFieldName), fieldType, null);
        JCTree.JCMethodInvocation mapGetCall = this.maker.Apply(List.nil(), this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString(mapFieldName)), this.names.fromString("get")), List.of(this.maker.Ident(methodParam.name)));
        JCTree.JCMethodDecl getterMethod = this.maker.MethodDef(this.maker.Modifiers(9L), this.names.fromString(methodName), enumIdent, List.nil(), List.of(methodParam), List.nil(), this.maker.Block(0L, List.of(this.maker.Return(mapGetCall))), null);
        classDecl.defs = classDecl.defs.append(getterMethod);
    }
}

