/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.processors;

import com.google.auto.service.AutoService;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import host.anzo.commons.processors.CommonProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jetbrains.annotations.NotNull;

@SupportedOptions(value={"CommonsCoreVerbose"})
@SupportedAnnotationTypes(value={"host.anzo.commons.annotations.processors.ExtendedEnum"})
@AutoService(value={Processor.class})
public class ExtendedEnumProcessor
extends CommonProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.maker == null || this.trees == null || this.names == null) {
            this.logError("Processor essentials not initialized. Skipping processing.");
            return false;
        }
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        TypeElement extendedEnumAnnotation = this.processingEnv.getElementUtils().getTypeElement("host.anzo.commons.annotations.processors.ExtendedEnum");
        if (extendedEnumAnnotation == null) {
            this.logError("Could not resolve host.anzo.commons.annotations.processors.ExtendedEnum annotation.");
            return false;
        }
        this.isVerbose = this.processingEnv.getOptions().containsKey("CommonsCoreVerbose");
        for (Element element : roundEnv.getElementsAnnotatedWith(extendedEnumAnnotation)) {
            if (element.getKind() == ElementKind.ENUM) {
                CompilationUnitTree cuTree;
                TreePath path = this.trees.getPath(element);
                if (path == null) {
                    this.logWarn("Could not get TreePath for element: " + String.valueOf(element.getSimpleName()));
                    continue;
                }
                if (this.isVerbose) {
                    this.log("Processing " + String.valueOf(element.getSimpleName()));
                }
                if ((cuTree = path.getCompilationUnit()) == null) {
                    this.logWarn("Could not get CompilationUnitTree for element: " + String.valueOf(element.getSimpleName()));
                    continue;
                }
                JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)cuTree;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)path.getLeaf();
                int currentPos = classDecl.pos;
                this.addCacheListField(classDecl, currentPos);
                this.addGetValueByOrdinalMethod(classDecl, currentPos);
                this.addGetValueByOrdinalInternalMethod(classDecl, currentPos);
                this.addGetValuesMethod(classDecl, currentPos);
                this.addGetValuesInternalMethod(classDecl, currentPos);
                ArrayList<JCTree.JCStatement> collectedPutStatements = new ArrayList<JCTree.JCStatement>();
                this.addNameCacheAndCollectPuts(classDecl, collectedPutStatements, currentPos);
                this.processCacheKeysAndCollectPuts(element, classDecl, collectedPutStatements, currentPos);
                if (!collectedPutStatements.isEmpty()) {
                    JCTree.JCIdent enumType = this.maker.Ident(classDecl.name);
                    Name loopVarName = this.names.fromString("enumConstant");
                    JCTree.JCVariableDecl loopVar = this.maker.at(currentPos).VarDef(this.maker.Modifiers(0L), loopVarName, enumType, null);
                    JCTree.JCMethodInvocation iterable = this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select((JCTree.JCExpression)enumType, this.names.fromString("values")), List.nil());
                    JCTree.JCBlock loopBody = this.maker.at(currentPos).Block(0L, List.from(collectedPutStatements));
                    JCTree.JCEnhancedForLoop foreachLoop = this.maker.at(currentPos).ForeachLoop(loopVar, iterable, loopBody);
                    this.addToStaticInitializer(classDecl, foreachLoop);
                }
                if (!this.isVerbose) continue;
                this.printCompilationUnitAst(compilationUnit);
                continue;
            }
            this.logWarn("@" + String.valueOf(extendedEnumAnnotation.getSimpleName()) + " applied to non-enum: " + String.valueOf(element.getSimpleName()));
        }
        return false;
    }

    private void addNameCacheAndCollectPuts(JCTree.JCClassDecl classDecl, java.util.List<JCTree.JCStatement> collectedPutStatements, int currentPos) {
        String mapFieldName = "cacheMap";
        JCTree.JCExpression keyType = this.createQualifiedName(currentPos, "java.lang.String");
        if (!this.fieldExists(classDecl, "cacheMap")) {
            this.addCacheMapField(classDecl, keyType, "cacheMap", currentPos);
        }
        String getterName = "getValueOf";
        if (!this.methodExists(classDecl, "getValueOf", 1)) {
            this.addCacheMapValueGetterMethod(classDecl, "name", keyType, "getValueOf", "cacheMap", false, currentPos);
            this.addCacheMapValueGetterInternalMethod(classDecl, "name", keyType, "getValueOf", false, currentPos);
        }
        if (!this.methodExists(classDecl, "getValueOf", 2)) {
            this.addCacheMapValueGetterMethod(classDecl, "name", keyType, "getValueOf", "cacheMap", true, currentPos);
            this.addCacheMapValueGetterInternalMethod(classDecl, "name", keyType, "getValueOf", true, currentPos);
        }
        JCTree.JCStatement putStmt = this.createCacheMapPutStatement(this.names.fromString("enumConstant"), "name", "cacheMap", true, currentPos);
        collectedPutStatements.add(putStmt);
    }

    private void addKeysCacheAndCollectPuts(JCTree.JCClassDecl classDecl, String accessorName, JCTree.JCExpression keyType, String mapFieldName, String getterMethodName, boolean isMethod, java.util.List<JCTree.JCStatement> collectedPutStatements, int currentPos) {
        if (!this.fieldExists(classDecl, mapFieldName)) {
            this.addCacheMapField(classDecl, keyType, mapFieldName, currentPos);
        }
        JCTree.JCStatement putStmt = this.createCacheMapPutStatement(this.names.fromString("enumConstant"), accessorName, mapFieldName, isMethod, currentPos);
        collectedPutStatements.add(putStmt);
        if (!this.methodExists(classDecl, getterMethodName, 1)) {
            this.addCacheMapValueGetterMethod(classDecl, accessorName, keyType, getterMethodName, mapFieldName, false, currentPos);
            this.addCacheMapValueGetterInternalMethod(classDecl, accessorName, keyType, getterMethodName, false, currentPos);
        }
        if (!this.methodExists(classDecl, getterMethodName, 2)) {
            this.addCacheMapValueGetterMethod(classDecl, accessorName, keyType, getterMethodName, mapFieldName, true, currentPos);
            this.addCacheMapValueGetterInternalMethod(classDecl, accessorName, keyType, getterMethodName, true, currentPos);
        }
    }

    private void processCacheKeysAndCollectPuts(Element classElement, JCTree.JCClassDecl classDecl, java.util.List<JCTree.JCStatement> collectedPutStatements, int currentPos) {
        Set<String> cacheKeys = this.getCacheKeyFieldNames(classElement);
        for (String cacheKeyName : cacheKeys) {
            boolean isMethod = cacheKeyName.endsWith("()");
            String cleanName = isMethod ? cacheKeyName.substring(0, cacheKeyName.length() - 2) : cacheKeyName;
            String mapFieldName = "cacheMapBy" + this.capitalize(cleanName);
            String getterMethodName = "getValueOf" + this.capitalize(cleanName);
            try {
                JCTree.JCExpression keyType = isMethod ? this.findMethodReturnType(classElement, cleanName, currentPos) : this.findFieldType(classDecl, cleanName);
                if (keyType == null) {
                    this.logError("In enum " + classDecl.name.toString() + ", " + (isMethod ? "method '" : "field '") + cleanName + "' not found for @ExtendedEnum cacheKey.");
                    continue;
                }
                JCTree.JCExpression mapKeyActualType = this.getBoxedType(keyType, currentPos);
                this.addKeysCacheAndCollectPuts(classDecl, cleanName, mapKeyActualType, mapFieldName, getterMethodName, isMethod, collectedPutStatements, currentPos);
            }
            catch (Exception e) {
                this.logError("Error processing accessor '" + cacheKeyName + "' for enum " + classDecl.name.toString() + ": " + e.getMessage());
            }
        }
    }

    @NotNull
    private Set<String> getCacheKeyFieldNames(@NotNull Element element) {
        HashSet<String> keys = new HashSet<String>();
        AnnotationMirror extendedEnumAnnotationMirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("host.anzo.commons.annotations.processors.ExtendedEnum")) continue;
            extendedEnumAnnotationMirror = annotationMirror;
            break;
        }
        if (extendedEnumAnnotationMirror != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = this.processingEnv.getElementUtils().getElementValuesWithDefaults(extendedEnumAnnotationMirror);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("cacheKeys")) continue;
                Object value = entry.getValue().getValue();
                if (!(value instanceof java.util.List)) break;
                for (Object item : (java.util.List)value) {
                    Object innerValue;
                    if (!(item instanceof AnnotationValue) || !((innerValue = ((AnnotationValue)item).getValue()) instanceof String)) continue;
                    keys.add((String)innerValue);
                }
            }
        }
        return keys;
    }

    private void addCacheListField(JCTree.JCClassDecl classDecl, int currentPos) {
        String fieldName = "cacheList";
        if (this.fieldExists(classDecl, "cacheList")) {
            return;
        }
        JCTree.JCTypeApply listType = this.maker.at(currentPos).TypeApply(this.createQualifiedName(currentPos, "java.util.List"), List.of(this.maker.at(currentPos).Ident(classDecl.name)));
        JCTree.JCMethodInvocation valuesCall = this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select((JCTree.JCExpression)this.maker.at(currentPos).Ident(classDecl.name), this.names.fromString("values")), List.nil());
        JCTree.JCMethodInvocation init = this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select(this.createQualifiedName(currentPos, "java.util.List"), this.names.fromString("of")), List.of(valuesCall));
        JCTree.JCVariableDecl cacheListField = this.maker.at(currentPos).VarDef(this.maker.Modifiers(26L), this.names.fromString("cacheList"), listType, init);
        classDecl.defs = classDecl.defs.append(cacheListField);
    }

    private void addGetValueByOrdinalMethod(JCTree.JCClassDecl classDecl, int currentPos) {
        String methodName = "getValue";
        if (this.methodExists(classDecl, "getValue", 1)) {
            return;
        }
        JCTree.JCMethodDecl method = this.maker.at(currentPos).MethodDef(this.maker.Modifiers(9L), this.names.fromString("getValue"), this.maker.at(currentPos).Ident(classDecl.name), List.nil(), List.of(this.maker.at(currentPos).VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("ordinal"), this.maker.at(currentPos).TypeIdent(TypeTag.INT), null)), List.nil(), this.maker.at(currentPos).Block(0L, List.of(this.maker.at(currentPos).Return(this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select((JCTree.JCExpression)this.maker.at(currentPos).Ident(this.names.fromString("cacheList")), this.names.fromString("get")), List.of(this.maker.at(currentPos).Ident(this.names.fromString("ordinal"))))))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addGetValueByOrdinalInternalMethod(JCTree.JCClassDecl classDecl, int currentPos) {
        String staticMethodName = "getValue";
        String internalMethodName = "getValueInternal";
        String paramName = "ordinal";
        if (this.methodExists(classDecl, "getValueInternal", 1)) {
            return;
        }
        JCTree.JCVariableDecl ordinalParam = this.maker.at(currentPos).VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("ordinal"), this.maker.TypeIdent(TypeTag.INT), null);
        JCTree.JCMethodInvocation staticMethodCall = this.maker.at(currentPos).Apply(List.nil(), this.maker.Ident(this.names.fromString("getValue")), List.of(this.maker.Ident(this.names.fromString("ordinal"))));
        JCTree.JCMethodDecl internalMethod = this.maker.at(currentPos).MethodDef(this.maker.Modifiers(1L), this.names.fromString("getValueInternal"), this.maker.Ident(classDecl.name), List.nil(), List.of(ordinalParam), List.nil(), this.maker.Block(0L, List.of(this.maker.Return(staticMethodCall))), null);
        classDecl.defs = classDecl.defs.append(internalMethod);
    }

    private void addGetValuesMethod(JCTree.JCClassDecl classDecl, int currentPos) {
        String methodName = "getValues";
        if (this.methodExists(classDecl, "getValues", 0)) {
            return;
        }
        JCTree.JCTypeApply returnType = this.maker.at(currentPos).TypeApply(this.createQualifiedName(currentPos, "java.util.List"), List.of(this.maker.at(currentPos).Ident(classDecl.name)));
        JCTree.JCMethodDecl method = this.maker.at(currentPos).MethodDef(this.maker.Modifiers(9L), this.names.fromString("getValues"), returnType, List.nil(), List.nil(), List.nil(), this.maker.at(currentPos).Block(0L, List.of(this.maker.at(currentPos).Return(this.maker.at(currentPos).Ident(this.names.fromString("cacheList"))))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addGetValuesInternalMethod(JCTree.JCClassDecl classDecl, int currentPos) {
        String staticMethodName = "getValues";
        String internalMethodName = "getValuesInternal";
        if (this.methodExists(classDecl, "getValuesInternal", 0)) {
            return;
        }
        JCTree.JCTypeApply returnType = this.maker.at(currentPos).TypeApply(this.createQualifiedName(currentPos, "java.util.List"), List.of(this.maker.Ident(classDecl.name)));
        JCTree.JCMethodInvocation staticMethodCall = this.maker.at(currentPos).Apply(List.nil(), this.maker.Ident(this.names.fromString("getValues")), List.nil());
        JCTree.JCMethodDecl internalMethod = this.maker.at(currentPos).MethodDef(this.maker.Modifiers(1L), this.names.fromString("getValuesInternal"), returnType, List.nil(), List.nil(), List.nil(), this.maker.Block(0L, List.of(this.maker.Return(staticMethodCall))), null);
        classDecl.defs = classDecl.defs.append(internalMethod);
    }

    private void addCacheMapField(@NotNull JCTree.JCClassDecl classDecl, JCTree.JCExpression keyType, String mapFieldName, int currentPos) {
        JCTree.JCIdent enumIdent = this.maker.at(currentPos).Ident(classDecl.name);
        JCTree.JCTypeApply mapGenericType = this.maker.at(currentPos).TypeApply(this.createQualifiedName(currentPos, "java.util.Map"), List.of(keyType, enumIdent));
        JCTree.JCNewClass newHashMapInstance = this.maker.at(currentPos).NewClass(null, List.nil(), this.maker.at(currentPos).TypeApply(this.createQualifiedName(currentPos, "java.util.HashMap"), List.nil()), List.nil(), null);
        JCTree.JCVariableDecl cacheMapVDef = this.maker.at(currentPos).VarDef(this.maker.Modifiers(26L), this.names.fromString(mapFieldName), mapGenericType, newHashMapInstance);
        classDecl.defs = classDecl.defs.append(cacheMapVDef);
    }

    private JCTree.JCStatement createCacheMapPutStatement(Name loopVarNameIdentifier, String originalAccessorName, String mapFieldName, boolean isAccessorMethod, int currentPos) {
        if (this.isVerbose) {
            this.log("Creating put statement: " + mapFieldName + ".put(" + loopVarNameIdentifier.toString() + "." + originalAccessorName + (isAccessorMethod ? "()" : "") + ", " + String.valueOf(loopVarNameIdentifier) + ")");
        }
        JCTree.JCIdent loopVarAccess = this.maker.at(currentPos).Ident(loopVarNameIdentifier);
        Name accessorAstName = this.names.fromString(originalAccessorName);
        JCTree.JCFieldAccess keyAccessExpression = isAccessorMethod ? this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select((JCTree.JCExpression)loopVarAccess, accessorAstName), List.nil()) : this.maker.at(currentPos).Select((JCTree.JCExpression)loopVarAccess, accessorAstName);
        JCTree.JCMethodInvocation containsKeyCall = this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select((JCTree.JCExpression)this.maker.at(currentPos).Ident(this.names.fromString(mapFieldName)), this.names.fromString("containsKey")), List.of(keyAccessExpression));
        JCTree.JCMethodInvocation putCall = this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select((JCTree.JCExpression)this.maker.at(currentPos).Ident(this.names.fromString(mapFieldName)), this.names.fromString("put")), List.of(keyAccessExpression, loopVarAccess));
        return this.maker.at(currentPos).If(this.maker.at(currentPos).Unary(JCTree.Tag.NOT, containsKeyCall), this.maker.at(currentPos).Exec(putCall), null);
    }

    private void addCacheMapValueGetterMethod(@NotNull JCTree.JCClassDecl classDecl, String keyParameterName, JCTree.JCExpression keyType, String methodName, String mapFieldName, boolean withDefault, int currentPos) {
        JCTree.JCIdent enumIdent = this.maker.at(currentPos).Ident(classDecl.name);
        List<JCTree.JCVariableDecl> params = List.of(this.maker.at(currentPos).VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString(keyParameterName), keyType, null));
        String mapAccessMethodName = "get";
        List<JCTree.JCExpression> mapAccessArgs = List.of(this.maker.at(currentPos).Ident(this.names.fromString(keyParameterName)));
        if (withDefault) {
            params = params.append(this.maker.at(currentPos).VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("defaultValue"), enumIdent, null));
            mapAccessMethodName = "getOrDefault";
            mapAccessArgs = mapAccessArgs.append(this.maker.at(currentPos).Ident(this.names.fromString("defaultValue")));
        }
        JCTree.JCMethodInvocation mapAccess = this.maker.at(currentPos).Apply(List.nil(), this.maker.at(currentPos).Select((JCTree.JCExpression)this.maker.at(currentPos).Ident(this.names.fromString(mapFieldName)), this.names.fromString(mapAccessMethodName)), mapAccessArgs);
        JCTree.JCMethodDecl method = this.maker.at(currentPos).MethodDef(this.maker.Modifiers(9L), this.names.fromString(methodName), enumIdent, List.nil(), params, List.nil(), this.maker.at(currentPos).Block(0L, List.of(this.maker.at(currentPos).Return(mapAccess))), null);
        classDecl.defs = classDecl.defs.append(method);
    }

    private void addCacheMapValueGetterInternalMethod(@NotNull JCTree.JCClassDecl classDecl, String keyParameterName, JCTree.JCExpression keyType, String staticGetterMethodName, boolean withDefault, int currentPos) {
        int paramCount;
        String internalGetterMethodName = staticGetterMethodName + "Internal";
        int n = paramCount = withDefault ? 2 : 1;
        if (this.methodExists(classDecl, internalGetterMethodName, paramCount)) {
            return;
        }
        JCTree.JCIdent enumIdent = this.maker.at(currentPos).Ident(classDecl.name);
        List<JCTree.JCVariableDecl> params = List.of(this.maker.at(currentPos).VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString(keyParameterName), keyType, null));
        List<JCTree.JCExpression> callArgs = List.of(this.maker.at(currentPos).Ident(this.names.fromString(keyParameterName)));
        if (withDefault) {
            String defaultValueParamName = "defaultValue";
            params = params.append(this.maker.at(currentPos).VarDef(this.maker.Modifiers(0x200000000L), this.names.fromString("defaultValue"), enumIdent, null));
            callArgs = callArgs.append(this.maker.at(currentPos).Ident(this.names.fromString("defaultValue")));
        }
        JCTree.JCMethodInvocation staticMethodCall = this.maker.at(currentPos).Apply(List.nil(), this.maker.Ident(this.names.fromString(staticGetterMethodName)), callArgs);
        JCTree.JCMethodDecl internalMethod = this.maker.at(currentPos).MethodDef(this.maker.Modifiers(1L), this.names.fromString(internalGetterMethodName), enumIdent, List.nil(), params, List.nil(), this.maker.Block(0L, List.of(this.maker.Return(staticMethodCall))), null);
        classDecl.defs = classDecl.defs.append(internalMethod);
    }
}

