/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.processors;

import com.sun.source.util.Trees;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import host.anzo.commons.processors.utils.Permit;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonProcessor
extends AbstractProcessor {
    protected TreeMaker maker;
    protected Trees trees;
    protected Messager messager;
    protected Names names;
    protected boolean isVerbose;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.messager = procEnv.getMessager();
        JavacProcessingEnvironment unwrappedProcEnv = this.getJavacProcessingEnvironment(procEnv);
        if (unwrappedProcEnv instanceof JavacProcessingEnvironment) {
            JavacProcessingEnvironment javacEnv = unwrappedProcEnv;
            this.maker = TreeMaker.instance(javacEnv.getContext());
            this.trees = Trees.instance(javacEnv);
            this.names = Names.instance(javacEnv.getContext());
        } else {
            this.logError("Could not obtain JavacProcessingEnvironment. Annotation processing might not work correctly. Original env: " + procEnv.getClass().getName());
        }
    }

    protected boolean fieldExists(@NotNull JCTree.JCClassDecl classDecl, String fieldName) {
        return classDecl.defs.stream().anyMatch(def -> def instanceof JCTree.JCVariableDecl && ((JCTree.JCVariableDecl)def).getName().contentEquals(fieldName));
    }

    protected boolean methodExists(@NotNull JCTree.JCClassDecl classDecl, String methodName, int paramCount) {
        return classDecl.defs.stream().anyMatch(def -> def instanceof JCTree.JCMethodDecl && ((JCTree.JCMethodDecl)def).getName().contentEquals(methodName) && ((List)((JCTree.JCMethodDecl)def).getParameters()).size() == paramCount);
    }

    protected JCTree.JCExpression createQualifiedName(int pos, @NotNull String fullTypeName) {
        this.maker.at(pos);
        String[] parts = fullTypeName.split("\\.");
        JCTree.JCExpression expr = this.maker.Ident(this.names.fromString(parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            expr = this.maker.Select(expr, this.names.fromString(parts[i]));
        }
        return expr;
    }

    @Nullable
    protected JCTree.JCExpression findFieldType(@NotNull JCTree.JCClassDecl classDecl, String fieldName) {
        for (JCTree def : classDecl.defs) {
            if (!(def instanceof JCTree.JCVariableDecl)) continue;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)def;
            if (!field.name.contentEquals(fieldName)) continue;
            return field.vartype;
        }
        return null;
    }

    protected JCTree.JCExpression findMethodReturnType(@NotNull Element element, String methodName, int pos) {
        TypeElement elementType = (TypeElement)element;
        for (Element element2 : this.processingEnv.getElementUtils().getAllMembers(elementType)) {
            if (element2.getKind() != ElementKind.METHOD || !element2.getSimpleName().contentEquals(methodName)) continue;
            ExecutableElement method = (ExecutableElement)element2;
            return this.createQualifiedName(pos, method.getReturnType().toString());
        }
        return null;
    }

    protected void addToStaticInitializer(@NotNull JCTree.JCClassDecl classDecl, JCTree.JCStatement stmt) {
        JCTree.JCBlock staticBlock = this.maker.Block(8L, List.of(stmt));
        classDecl.defs = classDecl.defs.append(staticBlock);
    }

    @NotNull
    protected String capitalize(@NotNull String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    @NotNull
    protected JCTree.JCExpression getBoxedType(@NotNull JCTree.JCExpression primitiveOrRefType, int pos) {
        if (primitiveOrRefType instanceof JCTree.JCPrimitiveTypeTree) {
            JCTree.JCPrimitiveTypeTree primitiveTypeTree = (JCTree.JCPrimitiveTypeTree)primitiveOrRefType;
            TypeTag tag = primitiveTypeTree.typetag;
            return switch (tag) {
                case TypeTag.BYTE -> this.createQualifiedName(pos, "java.lang.Byte");
                case TypeTag.SHORT -> this.createQualifiedName(pos, "java.lang.Short");
                case TypeTag.INT -> this.createQualifiedName(pos, "java.lang.Integer");
                case TypeTag.LONG -> this.createQualifiedName(pos, "java.lang.Long");
                case TypeTag.FLOAT -> this.createQualifiedName(pos, "java.lang.Float");
                case TypeTag.DOUBLE -> this.createQualifiedName(pos, "java.lang.Double");
                case TypeTag.CHAR -> this.createQualifiedName(pos, "java.lang.Character");
                case TypeTag.BOOLEAN -> this.createQualifiedName(pos, "java.lang.Boolean");
                default -> primitiveOrRefType;
            };
        }
        return primitiveOrRefType;
    }

    protected JavacProcessingEnvironment getJavacProcessingEnvironment(Object procEnv) {
        if (procEnv instanceof JavacProcessingEnvironment) {
            return (JavacProcessingEnvironment)procEnv;
        }
        for (Class<?> procEnvClass = procEnv.getClass(); procEnvClass != null; procEnvClass = procEnvClass.getSuperclass()) {
            Object delegate = this.tryGetDelegateField(procEnvClass, procEnv);
            if (delegate == null) {
                delegate = this.tryGetProxyDelegateToField(procEnvClass, procEnv);
            }
            if (delegate == null) {
                delegate = this.tryGetProcessingEnvField(procEnvClass, procEnv);
            }
            if (delegate == null) continue;
            return this.getJavacProcessingEnvironment(delegate);
        }
        return null;
    }

    @Nullable
    private Object tryGetProcessingEnvField(Class<?> delegateClass, Object instance) {
        try {
            return Permit.getField(delegateClass, "processingEnv").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private Object tryGetDelegateField(Class<?> delegateClass, Object instance) {
        try {
            return Permit.getField(delegateClass, "delegate").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private Object tryGetProxyDelegateToField(Class<?> delegateClass, Object instance) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(instance);
            return Permit.getField(handler.getClass(), "val$delegateTo").get(handler);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void printCompilationUnitAst(JCTree.JCCompilationUnit compilationUnit) {
        if (compilationUnit == null) {
            this.logWarn("Cannot print AST, compilation unit is null.");
            return;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Pretty printer = new Pretty(stringWriter, true);
            compilationUnit.accept(printer);
            this.log("AST for " + compilationUnit.getSourceFile().getName() + ":\n" + String.valueOf(stringWriter));
        }
        catch (Exception e) {
            this.logError("Error printing AST: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    protected void log(String msg) {
        if (this.messager != null) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "[" + this.getClass().getSimpleName() + "] " + msg);
        } else {
            System.out.println("NOTE: [" + this.getClass().getSimpleName() + "] " + msg + " (Messager not initialized)");
        }
    }

    protected void logError(String msg) {
        if (this.messager != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[" + this.getClass().getSimpleName() + "] " + msg);
        } else {
            System.err.println("ERROR: [" + this.getClass().getSimpleName() + "] " + msg + " (Messager not initialized)");
        }
    }

    protected void logWarn(String msg) {
        if (this.messager != null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "[" + this.getClass().getSimpleName() + "] " + msg);
        } else {
            System.out.println("WARN: [" + this.getClass().getSimpleName() + "] " + msg + " (Messager not initialized)");
        }
    }
}

