/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.emergency.memory.watchers;

import host.anzo.commons.emergency.memory.watchers.IMemoryWatcher;
import host.anzo.commons.emergency.memory.watchers.PoolListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import javax.management.NotificationEmitter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class G1Watcher
implements IMemoryWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(G1Watcher.class);

    @Override
    public void register(MemoryPoolMXBean pool) {
        long max = pool.getUsage().getMax();
        pool.setUsageThreshold(Math.round((double)max * 0.85));
        NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        emitter.addNotificationListener(new PoolListener(pool), null, null);
        log.info("Listening {}", (Object)pool.getName());
    }

    @Override
    public boolean isValid(MemoryPoolMXBean pool) {
        return pool.getType() == MemoryType.HEAP && pool.isUsageThresholdSupported() && pool.isCollectionUsageThresholdSupported() && pool.getName().startsWith("G1");
    }
}

