/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static Object singletonInstance(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            throw null;
        }
    }

    public static Object singletonInstanceMethod(Class<?> clazz, Method method) {
        try {
            Object singletonInstance = ClassUtils.singletonInstance(clazz);
            if (singletonInstance != null) {
                return method.invoke(singletonInstance, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    @NotNull
    public static Collection<Method> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotation) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Class<?> klass = type; klass != Object.class; klass = klass.getSuperclass()) {
            List<Method> allMethods = Arrays.stream(klass.getMethods()).filter(method -> method.isAnnotationPresent(annotation)).toList();
            for (Method method2 : allMethods) {
                if (methods.containsKey(method2.getName())) continue;
                methods.put(method2.getName(), method2);
            }
        }
        return methods.values();
    }
}

