package host.anzo.core.startup;

import host.anzo.commons.utils.ClassUtils;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.lang.reflect.Method;
import java.util.*;
import java.util.stream.Stream;

/**
 * @author ANZO
 * @since 20.04.2018
 */
public class StartModule<SL extends Enum<SL>> {
	private final List<StartModule<SL>> dependency = new ArrayList<>(0);
	private @Getter final Map<String, List<StartupMethodInfo>> beforeMethods = new HashMap<>();
	private @Getter final Map<String, List<StartupMethodInfo>> afterMethods = new HashMap<>();

	private @Getter final SL startLevel;
	private @Getter final Class<?> clazz;
	private @Getter Object instance;

	public StartModule(SL startLevel, @NotNull Class<?> clazz) {
		this.startLevel = startLevel;
		this.clazz = clazz;
		for (Method method : Stream.concat(Arrays.stream(clazz.getDeclaredMethods()), Arrays.stream(clazz.getSuperclass().getDeclaredMethods())).toList()) {
			if (method.isAnnotationPresent(StartupRun.class)) {
				final StartupRun startupRun = method.getAnnotation(StartupRun.class);
				if (!StringUtils.isEmpty(startupRun.after())) {
					afterMethods.computeIfAbsent(startupRun.after(), k -> new ArrayList<>()).add(new StartupMethodInfo(clazz, method, startupRun.isAsync()));
				}
				else if (!StringUtils.isEmpty(startupRun.before())) {
					beforeMethods.computeIfAbsent(startupRun.before(), k -> new ArrayList<>()).add(new StartupMethodInfo(clazz, method, startupRun.isAsync()));
				}
			}
		}
	}

	public void addDependency(StartModule<SL> module) {
		dependency.add(module);
	}

	public void init() {
		if(instance != null) {
			// Cannot allow to secondary init
			return;
		}

		for(StartModule<SL> depend : dependency) {
			depend.init();
		}

		instance = ClassUtils.singletonInstance(clazz);

		final Collection<Method> scheduledMethods = ClassUtils.getMethodsAnnotatedWith(clazz, Scheduled.class);
		for (Method scheduledMethod : scheduledMethods) {
			ScheduledService.getInstance().addScheduledMethod(clazz, scheduledMethod);
		}
	}

	@Override
	public String toString() {
		return clazz.getSimpleName();
	}
}