/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.emergency.deadlock;

import host.anzo.commons.emergency.deadlock.IDeadlockListener;
import host.anzo.core.startup.StartupComponent;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Diagnostic")
public class DeadlockDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeadlockDetector.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    private final List<IDeadlockListener> listeners = new ArrayList<IDeadlockListener>();
    private boolean isDeadlockFound = false;

    private DeadlockDetector() {
        new Timer("Deadlock detector", true).schedule(new TimerTask(){

            @Override
            public void run() {
                long[] ids = DeadlockDetector.this.mbean.findMonitorDeadlockedThreads();
                if (ids != null && ids.length > 0 && !DeadlockDetector.this.isDeadlockFound) {
                    DeadlockDetector.this.isDeadlockFound = true;
                    ThreadInfo[] threadInfos = DeadlockDetector.this.mbean.getThreadInfo(ids, true, true);
                    StringBuilder info = new StringBuilder();
                    info.append("DeadLock Found!\n");
                    for (ThreadInfo threadInfo : threadInfos) {
                        info.append(threadInfo.toString());
                    }
                    for (ThreadInfo ti : threadInfos) {
                        LockInfo[] locks = ti.getLockedSynchronizers();
                        MonitorInfo[] monitors = ti.getLockedMonitors();
                        if (locks.length == 0 && monitors.length == 0) continue;
                        ThreadInfo dl = ti;
                        info.append("Java-level deadlock:\n");
                        info.append('\t');
                        info.append(dl.getThreadName());
                        info.append(" is waiting to lock ");
                        info.append(dl.getLockInfo().toString());
                        info.append(" which is held by ");
                        info.append(dl.getLockOwnerName()).append("\n");
                        while ((dl = DeadlockDetector.this.mbean.getThreadInfo(new long[]{dl.getLockOwnerId()}, true, true)[0]).getThreadId() != ti.getThreadId()) {
                            info.append('\t');
                            info.append(dl.getThreadName());
                            info.append(" is waiting to lock ");
                            info.append(dl.getLockInfo().toString());
                            info.append(" which is held by ");
                            info.append(dl.getLockOwnerName()).append("\n");
                        }
                    }
                    System.out.println(info);
                    log.warn(info.toString());
                    DeadlockDetector.this.listeners.forEach(listener -> listener.deadlockDetected(threadInfos));
                    DeadlockDetector.this.killDeadlockedThreads(ids);
                }
            }
        }, 0L, 5000L);
        log.info("DeadLockDetector started.");
    }

    private void killDeadlockedThreads(long[] ids) {
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            if (!ArrayUtils.contains((long[])ids, (long)entry.getKey().getId())) continue;
            entry.getKey().interrupt();
        }
    }

    public void registerListener(IDeadlockListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static DeadlockDetector getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    DeadlockDetector actualValue = new DeadlockDetector();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (DeadlockDetector)($value == instance ? null : $value);
    }
}

