/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static Object singletonInstance(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            throw null;
        }
    }

    public static Object singletonInstanceMethod(Class<?> clazz, Method method) {
        try {
            Object singletonInstance = ClassUtils.singletonInstance(clazz);
            if (singletonInstance != null) {
                return method.invoke(singletonInstance, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    @NotNull
    public static Collection<Method> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotation) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Class<?> klass = type; klass != Object.class; klass = klass.getSuperclass()) {
            List<Method> allMethods = Arrays.stream(klass.getMethods()).filter(method -> method.isAnnotationPresent(annotation)).toList();
            for (Method method2 : allMethods) {
                if (!methods.containsKey(method2.getName())) {
                    methods.put(method2.getName(), method2);
                    continue;
                }
                log.error("Class [{}] contains duplicate method [{}] (original class [{}])", new Object[]{klass.getName(), method2.getName(), type});
            }
        }
        return methods.values();
    }

    @Nullable
    public static Class<?> lookupClassQuietly(String name) {
        try {
            return ClassUtils.class.getClassLoader().loadClass(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public static Map<String, Object> getFieldValues(@NotNull Class<?> clazz) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                fieldValues.put(field.getName(), field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return fieldValues;
    }

    public static void initFieldsFromMap(Object object, @NotNull Map<String, Object> fieldValues) {
        for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            try {
                Field objectField = object.getClass().getField(fieldName);
                objectField.set(object, fieldValue);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(@NotNull Class<T> clazz, Class<?> ... parameterTypes) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != parameterTypes.length) continue;
            boolean paramsMatch = true;
            for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
                if (constructor.getParameterTypes()[paramIndex].equals(parameterTypes[paramIndex])) continue;
                paramsMatch = false;
                break;
            }
            if (!paramsMatch) continue;
            return constructor;
        }
        return null;
    }

    public static boolean hasConstructor(@NotNull Class<?> clazz, Class<?> ... parameterTypes) {
        return ClassUtils.getConstructor(clazz, parameterTypes) != null;
    }

    @NotNull
    public static ClassLoader addJars(@NotNull List<File> jarFiles) throws IOException {
        URL[] jarUrls = new URL[jarFiles.size()];
        for (int i = 0; i < jarFiles.size(); ++i) {
            jarUrls[i] = jarFiles.get(i).toURI().toURL();
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (!(systemClassLoader instanceof URLClassLoader)) {
            URLClassLoader urlClassLoader = new URLClassLoader(jarUrls, systemClassLoader);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            return urlClassLoader;
        }
        return systemClassLoader;
    }
}

