/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.collection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapSplitter<K, V> {
    private TreeMap<K, V> map;
    private List<K> keys;
    private int splitCount;
    private int currentIndex = 0;

    public MapSplitter(Map<K, V> map, int splitCount) {
        if (map != null) {
            this.map = new TreeMap<K, V>(map);
            this.keys = new ArrayList<K>(this.map.keySet());
            this.splitCount = splitCount;
        }
    }

    public MapSplitter(Map<K, V> map, Comparator<? super K> comparator, int splitCount) {
        if (map != null) {
            this.map = new TreeMap(comparator);
            this.map.putAll(map);
            this.keys = new ArrayList<K>(this.map.keySet());
            this.splitCount = splitCount;
        }
    }

    public Map<K, V> getNext(int splitCount) {
        this.splitCount = splitCount;
        return this.getNext();
    }

    public Map<K, V> getNext() {
        SortedMap<K, V> chunk = this.currentIndex + this.splitCount < this.map.size() ? this.map.subMap(this.keys.get(this.currentIndex), this.keys.get(this.currentIndex + this.splitCount)) : this.map.tailMap(this.keys.get(this.currentIndex));
        this.currentIndex += this.splitCount;
        return chunk;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isFirst() {
        return this.currentIndex <= this.splitCount;
    }

    public boolean isLast() {
        return this.currentIndex == this.map.size();
    }

    public boolean hasNext() {
        return this.currentIndex < this.map.size();
    }
}

