/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Arrays;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBinaryWriter
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileBinaryWriter.class);
    private ByteBuffer byteBuffer;
    private FileChannel roChannel = null;

    public FileBinaryWriter(int capacity) {
        this(ByteBuffer.allocate(capacity));
    }

    public FileBinaryWriter(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public FileBinaryWriter(@NotNull Path path) throws IOException {
        this.roChannel = new RandomAccessFile(path.toFile(), "r").getChannel();
        this.byteBuffer = this.roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.roChannel.size()).load();
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    private FileBinaryWriter(byte[] byteBuffer) {
        this(ByteBuffer.wrap(byteBuffer));
    }

    public void writeC(int data) {
        this.byteBuffer.put((byte)data);
    }

    public void writeCB(boolean value) {
        this.byteBuffer.put(value ? (byte)1 : 0);
    }

    public void writeF(float value) {
        this.byteBuffer.putFloat(value);
    }

    public void writeFF(double value) {
        this.byteBuffer.putDouble(value);
    }

    public void writeH(int value) {
        this.byteBuffer.putShort((short)value);
    }

    public void writeD(int value) {
        this.byteBuffer.putInt(value);
    }

    public void writeD(long value) {
        this.byteBuffer.putInt((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    public void writeQ(long value) {
        this.byteBuffer.putLong(value);
    }

    public void writeB(byte[] data) {
        this.byteBuffer.put(data);
    }

    public void writeB(byte data) {
        this.byteBuffer.put(data);
    }

    public void writeS(CharSequence charSequence) {
        if (charSequence != null) {
            int length = charSequence.length();
            for (int i = 0; i < length; ++i) {
                this.byteBuffer.putChar(charSequence.charAt(i));
            }
        }
        this.byteBuffer.putChar('\u0000');
    }

    public final void writeS(CharSequence charSequence, int size) {
        if (charSequence == null) {
            this.byteBuffer.put(new byte[size]);
        } else {
            int startPosition = this.byteBuffer.position();
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.byteBuffer.position() - startPosition >= size) continue;
                this.byteBuffer.putChar(charSequence.charAt(i));
            }
            int length = this.byteBuffer.position() - startPosition;
            if (length < size) {
                this.writeB(new byte[size - length]);
            }
        }
    }

    public void writeQS(@NotNull CharSequence charSequence) {
        int length = charSequence.length();
        this.writeQ(length);
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.putChar(charSequence.charAt(i));
        }
    }

    public void write(@NotNull Field field, Object object) throws IllegalAccessException {
        switch (field.getType().getTypeName()) {
            case "java.lang.Byte": 
            case "byte": 
            case "java.lang.Boolean": 
            case "boolean": {
                this.writeB(field.getByte(object));
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                this.writeD(field.getInt(object));
                break;
            }
            case "java.lang.Short": 
            case "short": {
                this.writeH(field.getShort(object));
                break;
            }
            case "java.lang.Long": 
            case "long": {
                this.writeQ(field.getLong(object));
                break;
            }
            case "java.lang.Float": 
            case "float": {
                this.writeF(field.getFloat(object));
                break;
            }
            case "java.lang.Double": 
            case "double": {
                this.writeFF(field.getDouble(object));
            }
            default: {
                log.error("Unsupported class [{}]", (Object)field.getType().getTypeName());
            }
        }
    }

    public void setPosition(int position) {
        this.byteBuffer.position(position);
    }

    public int getPosition() {
        return this.byteBuffer.position();
    }

    public String getPositionHex() {
        return Integer.toHexString(this.getPosition());
    }

    public int getAvailableBytes() {
        return this.byteBuffer.remaining();
    }

    public void trim() {
        int dataEndPosition = this.getPosition();
        this.byteBuffer = ByteBuffer.wrap(this.byteBuffer.array(), 0, dataEndPosition);
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.byteBuffer.array(), 0, this.getPosition());
    }

    public void writeToFile(Path path) {
        try (FileOutputStream outputStream = new FileOutputStream(path.toFile(), false);
             FileChannel channel = outputStream.getChannel();){
            this.trim();
            channel.write(this.byteBuffer);
        }
        catch (Exception e) {
            log.error("Error while writing buffer to file [{}]", (Object)path.toString(), (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.roChannel != null) {
            try {
                this.roChannel.close();
            }
            catch (IOException e) {
                log.error("Error while closing FileBinaryWriter channel!", (Throwable)e);
            }
        }
        if (this.byteBuffer != null) {
            try {
                this.byteBuffer.clear();
            }
            catch (Exception e) {
                log.error("Error while closing FileBinaryWriter buffer!", (Throwable)e);
            }
        }
    }

    @Generated
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }
}

