/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.commons.network.iprange.IP4Range;
import host.anzo.commons.network.iprange.IP6Range;
import host.anzo.core.startup.IReloadable;
import host.anzo.core.startup.Reloadable;
import host.anzo.core.startup.StartupComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Reloadable(name="cloudflare", group="service")
@StartupComponent(value="Service")
public class CloudflareService
implements IReloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudflareService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final String CF_IP4_RANGES_URL = "https://www.cloudflare.com/ips-v4";
    private static final String CF_IP6_RANGES_URL = "https://www.cloudflare.com/ips-v6";
    public static final String CF_RAY = "CF-RAY";
    public static final String CF_CONNECTING_IP = "CF-Connecting-IP";
    public static final String CF_IPCOUNTRY = "CF-IPCountry";
    private final List<IP4Range> CLOUDFLARE_IP4_RANGES = new ArrayList<IP4Range>();
    private final List<IP6Range> CLOUDFLARE_IP6_RANGES = new ArrayList<IP6Range>();

    public CloudflareService() {
        this.load();
    }

    private void load() {
        try {
            for (String ip : this.getCloudflareIPs(CF_IP4_RANGES_URL)) {
                this.CLOUDFLARE_IP4_RANGES.add(new IP4Range(ip));
            }
            for (String ip : this.getCloudflareIPs(CF_IP6_RANGES_URL)) {
                this.CLOUDFLARE_IP6_RANGES.add(new IP6Range(ip));
            }
            log.info("Loaded {} Cloudflare IP4 ranges", (Object)this.CLOUDFLARE_IP4_RANGES.size());
            log.info("Loaded {} Cloudflare IP6 ranges", (Object)this.CLOUDFLARE_IP6_RANGES.size());
        }
        catch (IOException e) {
            log.error("Error loading Cloudflare IP ranges", (Throwable)e);
        }
    }

    @NotNull
    private List<String> getCloudflareIPs(String url_string) throws IOException {
        try {
            String line;
            ArrayList<String> cloudflareIPs = new ArrayList<String>();
            URL url = new URL(url_string);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = reader.readLine()) != null) {
                cloudflareIPs.add(line.trim());
            }
            reader.close();
            return cloudflareIPs;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean isCloudflareIP(String ip) {
        try {
            return this.isCloudflareIP(InetAddress.getByName(ip));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCloudflareIP(InetAddress inetAddress) {
        if (inetAddress == null || inetAddress.isLoopbackAddress()) {
            return false;
        }
        for (IP4Range range : this.CLOUDFLARE_IP4_RANGES) {
            if (!range.contains(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return !this.CLOUDFLARE_IP4_RANGES.isEmpty();
    }

    @Override
    public void reload() {
        this.CLOUDFLARE_IP4_RANGES.clear();
        this.CLOUDFLARE_IP6_RANGES.clear();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static CloudflareService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    CloudflareService actualValue = new CloudflareService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (CloudflareService)($value == instance ? null : $value);
    }
}

