package host.anzo.commons.emergency.metric;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.utils.ClassUtils;
import host.anzo.core.startup.StartupComponent;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.text.TextStringBuilder;

import java.lang.reflect.Modifier;
import java.util.*;

/**
 * @author ANZO
 */
@Slf4j
@StartupComponent("Diagnostic")
public class MetricService {
	@Getter(lazy=true)
	private final static MetricService instance = new MetricService();

	private MetricService() {
	}

	public String getMetrics() {
		final TextStringBuilder allBuilder = new TextStringBuilder("{").appendln("\"version\": \"1.0.0\",");
		final Map<MetricGroupType, List<String>> metricsResult = new HashMap<>();
		final Set<Class<?>> parentMetrics = new HashSet<>();
		ClassIndex.getAnnotated(Metric.class).forEach(clazz -> {
			if (IMetric.class.isAssignableFrom(clazz)
					&& !Modifier.isAbstract(clazz.getModifiers())) {
				boolean canBeAdded = true;
				final Metric metricAnnotation = clazz.getAnnotation(Metric.class);
				if (metricAnnotation.fromParent() && parentMetrics.contains(clazz.getSuperclass())) {
					canBeAdded = false;
				}

				if (canBeAdded) {
					if (metricAnnotation.fromParent()) {
						parentMetrics.add(clazz.getSuperclass());
					}
					final Object singletonObject = ClassUtils.singletonInstance(clazz);
					if (singletonObject != null) {
						final List<MetricResult> metrics = ((IMetric) singletonObject).getMetric();
						for (MetricResult metric : metrics) {
							metricsResult.computeIfAbsent(metric.getMetricGroupType(), k -> new ArrayList<>()).add("\"" + metric.getName() + "\" : " + metric.getData());
						}
					}
				}
			}
		});

		final List<String> metricGroupResults = new ArrayList<>();
		for (Map.Entry<MetricGroupType, List<String>> entry : metricsResult.entrySet()) {
			metricGroupResults.add("\"" + entry.getKey() + "\" : {" + String.join(",", entry.getValue()) +"}");
		}
		allBuilder.appendln(String.join(",", metricGroupResults));
		allBuilder.appendln("}");
		return allBuilder.get();
	}
}