package host.anzo.core.webserver.utils;

import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import spark.Response;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author ANZO
 * @since 05.06.2017
 */
public class JsonResultBuilder {
	private final Map<String, Object> params = new LinkedHashMap<>();
	private Response response;

	public JsonResultBuilder() {
	}

	public JsonResultBuilder(@NotNull Response response) {
		response.type("application/json");
		this.response = response;
	}

	public JsonResultBuilder(@NotNull Response response, int resultCode) {
		this(response);
		params.put("resultCode", resultCode);
		params.put("result", resultCode);
	}

	public JsonResultBuilder with(String key, @NotNull Object value) {
		params.put(key, value);
		return this;
	}

	public JsonResultBuilder withString(String key, @NotNull Object value) {
		params.put(key, value.toString());
		return this;
	}

	public JsonResultBuilder withStatus(int status) {
		if (response != null) {
			response.status(status);
		}
		return this;
	}

	public String build() {
		final TextStringBuilder builder = new TextStringBuilder("{");
		int paramCount = params.size();
		for(Map.Entry<String, Object> entry : params.entrySet()) {
			paramCount--;
			builder.append("\"").append(entry.getKey()).append("\" : ");
			if (entry.getValue() instanceof String) {
				builder.append("\"").append(entry.getValue()).append("\"");
			}
			else {
				builder.append(entry.getValue());
			}
			if (paramCount > 0) {
				builder.append(", ");
			}
		}
		builder.append("}");
		return builder.build();
	}

	@Override
	public String toString() {
		return build();
	}
}