/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.config;

import host.anzo.commons.config.annotation.ConfigComments;
import host.anzo.commons.config.annotation.ConfigFile;
import host.anzo.commons.config.annotation.ConfigProperty;
import host.anzo.commons.model.enums.EFirewallType;
import host.anzo.commons.model.enums.ERestrictionType;
import java.util.ArrayList;
import java.util.List;

@ConfigFile(name="config/firewall.properties")
public class FirewallConfig {
    @ConfigComments(comment={"Firewall type", "DISABLED - Disabled", "INTERNAL - Use application firewall (resets every application restart)", "SYSTEM - Use system firewall (iptables for example, resets every OS restart)", "Default: INTERNAL"})
    @ConfigProperty(name="FirewallType", value="INTERNAL")
    public static EFirewallType FIREWALL_TYPE;
    @ConfigComments(comment={"Firewall ban time", "Default: 30000"})
    @ConfigProperty(name="FirewallBanTime", value="30000")
    public static long FIREWALL_BAN_TIME;
    @ConfigComments(comment={"Maximum CONNECT attempts per second from client.", "Default: 3"})
    @ConfigProperty(name="FirewallMaxConnectsPerSecond", value="3")
    public static int FIREWALL_MAX_CONNECTS_PER_SECOND;
    @ConfigComments(comment={"Action applied to IP exceeded connection limit", "Default: BAN"})
    @ConfigProperty(name="FirewallMaxConnectsPerSecondRestrict", value="BAN")
    public static ERestrictionType FIREWALL_MAX_CONNECTS_PER_SECOND_RESTRICT;
    @ConfigComments(comment={"Maximum packet rate per second for each packet (count separately per packet type)", "Default: 20"})
    @ConfigProperty(name="FirewallMaxPacketsPerSecond", value="20")
    public static double FIREWALL_MAX_PACKETS_PER_SECOND;
    @ConfigComments(comment={"Action applied to connection exceeded packet per second limit", "Default: DROP"})
    @ConfigProperty(name="FirewallMaxPacketsPerSecondRestrict", value="DROP")
    public static ERestrictionType FIREWALL_MAX_PACKETS_PER_SECOND_RESTRICT;
    @ConfigComments(comment={"System drop firewall command executed when restrict reached.", "Default: nft add element inet filter blocked_ips { $ip }"})
    @ConfigProperty(name="FirewallSystemFirewallRule", value="nft add element inet filter blocked_ips { $ip }")
    public static String FIREWALL_SYSTEM_FIREWALL_RULE;
    @ConfigComments(comment={"List of blocked countries", "Default: China, India"})
    @ConfigProperty(name="FirewallBannedCountries", value="China, India")
    public static List<String> FIREWALL_BANNED_COUNTRIES;
    @ConfigComments(comment={"Address collections will be removed after application started.", "Command like this will be generated and executed: nft flush set inet filter blocked_ips", "Needed to revoke portknock authorization and unban blocked addresses", "Default: blocked_ips,blocked_temporary,port_knocking_ips"})
    @ConfigProperty(name="FirewallFlushedSetsBeforeStart", value="blocked_ips,blocked_temporary,port_knocking_ips")
    public static List<String> FIREWALL_FLUSHED_SETS_BEFORE_START;

    static {
        FIREWALL_BANNED_COUNTRIES = new ArrayList<String>();
        FIREWALL_FLUSHED_SETS_BEFORE_START = new ArrayList<String>();
    }
}

