/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.startup;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.utils.ClassUtils;
import host.anzo.core.startup.IReloadable;
import host.anzo.core.startup.Reloadable;
import host.anzo.core.startup.StartupComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class ReloadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReloadService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, Map<String, Class<?>>> classTree = new HashMap();

    private ReloadService() {
        ClassIndex.getAnnotated(Reloadable.class).forEach(item -> {
            Reloadable annotation = item.getAnnotation(Reloadable.class);
            if (annotation != null) {
                if (IReloadable.class.isAssignableFrom((Class<?>)item)) {
                    String name = annotation.name();
                    String group = annotation.group();
                    this.classTree.computeIfAbsent(group, m -> new HashMap()).putIfAbsent(name, item);
                } else {
                    throw new RuntimeException("Found marked with Reloadable annotation class, but without IReloadable implementing: " + item.getSimpleName());
                }
            }
        });
        log.info("Loaded {} reloadable instances.", (Object)this.classTree.values().stream().mapToLong(item -> item.values().size()).sum());
    }

    private void callReload(Class<?> clazz) {
        Object object = ClassUtils.singletonInstance(clazz);
        if (object != null) {
            if (object instanceof IReloadable) {
                ((IReloadable)object).reload();
            }
        } else {
            log.error("Can't find singleton for class=[{}]", (Object)clazz.getSimpleName());
        }
    }

    public int reloadByName(String name) {
        int count = 0;
        for (Map<String, Class<?>> classMap : this.classTree.values()) {
            for (Map.Entry<String, Class<?>> classEntry : classMap.entrySet()) {
                if (!classEntry.getKey().equalsIgnoreCase(name)) continue;
                this.callReload(classEntry.getValue());
                ++count;
            }
        }
        return count;
    }

    public int reloadByGroup(String group) {
        int count = 0;
        if (this.classTree.containsKey(group)) {
            Collection<Class<?>> classes = this.classTree.get(group).values();
            for (Class<?> clazz : classes) {
                this.callReload(clazz);
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ReloadService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ReloadService actualValue = new ReloadService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ReloadService)($value == instance ? null : $value);
    }
}

