/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.webserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import host.anzo.commons.config.ConfigTypeCaster;
import host.anzo.commons.utils.JsonUtils;
import host.anzo.core.service.HttpService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;

public abstract class AWebRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWebRequest.class);
    @JsonIgnore
    private Map<String, String[]> queryMap;
    @JsonIgnore
    private final Map<String, Map<String, String[]>> maps = new HashMap<String, Map<String, String[]>>();
    @JsonIgnore
    private final Map<String, List<String>> lists = new HashMap<String, List<String>>();
    @JsonIgnore
    private final Map<String, String> params = new HashMap<String, String>();

    protected AWebRequest() {
    }

    public AWebRequest(Request request) {
        if (request != null) {
            this.params.putAll(request.params());
            this.queryMap = request.queryMap().toMap();
            for (Map.Entry<String, String[]> entry : this.queryMap.entrySet()) {
                if (entry.getValue() != null || request.queryMap(entry.getKey()) == null) continue;
                this.maps.put(entry.getKey(), request.queryMap(entry.getKey()).toMap());
            }
            for (Map.Entry<String, Object> entry : request.raw().getParameterMap().entrySet()) {
                if (this.maps.containsKey(entry.getKey()) || !entry.getKey().contains("[]")) continue;
                String key = entry.getKey().replace("[]", "");
                for (String value : (String[])entry.getValue()) {
                    this.lists.computeIfAbsent(key, k -> new ArrayList()).add(value);
                }
            }
        }
    }

    protected String getString(String paramName) {
        return this.getString(paramName, "");
    }

    protected String getString(String paramName, String defaultValue) {
        if (this.queryMap != null && this.queryMap.containsKey(paramName) && this.queryMap.get(paramName) != null) {
            return HttpService.getInstance().stripXSS(this.queryMap.get(paramName)[0]).replaceAll("\\.\\./", "");
        }
        return defaultValue;
    }

    protected long getLong(String paramName) {
        if (this.queryMap != null && this.queryMap.containsKey(paramName) && this.queryMap.get(paramName) != null && StringUtils.isNoneEmpty((CharSequence[])this.queryMap.get(paramName))) {
            try {
                return Long.parseLong(this.queryMap.get(paramName)[0].trim());
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    protected int getInteger(String paramName) {
        return this.getInteger(paramName, 0);
    }

    protected int getInteger(String paramName, int defaultValue) {
        if (this.queryMap != null && this.queryMap.containsKey(paramName) && this.queryMap.get(paramName) != null && StringUtils.isNoneEmpty((CharSequence[])this.queryMap.get(paramName))) {
            try {
                return Integer.parseInt(this.queryMap.get(paramName)[0].trim());
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    protected double getDouble(String paramName) {
        return this.getDouble(paramName, 0.0);
    }

    protected double getDouble(String paramName, double defaultValue) {
        if (this.queryMap != null && this.queryMap.containsKey(paramName) && this.queryMap.get(paramName) != null && StringUtils.isNoneEmpty((CharSequence[])this.queryMap.get(paramName))) {
            try {
                return Double.parseDouble(this.queryMap.get(paramName)[0].trim());
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    protected boolean getBoolean(String paramName) {
        if (this.queryMap != null && this.queryMap.containsKey(paramName) && this.queryMap.get(paramName) != null) {
            try {
                return Boolean.parseBoolean(this.queryMap.get(paramName)[0].toLowerCase().trim());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected Map<String, String> getMap(String paramName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.maps.containsKey(paramName) && this.maps.get(paramName) != null) {
            for (Map.Entry<String, String[]> entry : this.maps.get(paramName).entrySet()) {
                map.put(entry.getKey(), entry.getValue()[0]);
            }
        }
        return map;
    }

    protected <T> List<T> getList(Class<T> type, String paramName) {
        List<String> stringList = this.lists.get(paramName);
        if (stringList == null) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (String stringValue : stringList) {
            try {
                result.add(ConfigTypeCaster.cast(type, stringValue));
            }
            catch (Exception e) {
                log.error("Can't cast {} value to {}", (Object)stringValue, type);
            }
        }
        return result;
    }

    protected <T> T getJson(String paramName, Class<T> clazz) {
        String stringValue = StringEscapeUtils.unescapeHtml4((String)this.getString(paramName));
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{stringValue})) {
            try {
                return JsonUtils.jsonToObject(stringValue, clazz);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }
        return null;
    }

    public String getParam(String paramName) {
        return this.params.get(paramName);
    }

    protected Map<String, String> getParams() {
        return this.params;
    }
}

