package host.anzo.commons.emergency.memory.watchers;

import lombok.extern.slf4j.Slf4j;

import javax.management.NotificationEmitter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;

/**
 * @author ANZO
 * @since 08.07.2017
 */
@Slf4j
public class G1Watcher implements IMemoryWatcher {
	public G1Watcher() {
	}
	
	@Override
	public void register(MemoryPoolMXBean pool) {
		long max = pool.getUsage().getMax();
		pool.setUsageThreshold(Math.round(max * 0.85));
		
		NotificationEmitter emitter = (NotificationEmitter) ManagementFactory.getMemoryMXBean();
		emitter.addNotificationListener(new PoolListener(pool), null, null);
		log.info("Listening {}", pool.getName());
	}
	
	@Override
	public boolean isValid(MemoryPoolMXBean pool) {
		return pool.getType() == MemoryType.HEAP && pool.isUsageThresholdSupported() && pool.isCollectionUsageThresholdSupported()
				&& pool.getName().startsWith("G1");
	}
}