/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.threading;

import de.mxro.metrics.jre.Metrics;
import delight.async.properties.PropertyNode;
import host.anzo.commons.emergency.metric.IMetric;
import host.anzo.commons.emergency.metric.Metric;
import host.anzo.commons.emergency.metric.MetricGroupType;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.commons.threading.RunnableWrapper;
import host.anzo.commons.threading.ThreadPoolPriorityFactory;
import host.anzo.core.config.EmergencyConfig;
import host.anzo.core.startup.EShutdownPriority;
import host.anzo.core.startup.IShutdownable;
import host.anzo.core.startup.StartupComponent;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metric
@StartupComponent(value="Threading", shutdownPriority=EShutdownPriority.MINOR)
public final class ThreadPool
implements IShutdownable,
IMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPool.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final ScheduledThreadPoolExecutor generalThreadPool;
    private final ScheduledFuture<?> purgeTask;
    private final AtomicBoolean shutdowning = new AtomicBoolean(false);
    private static final PropertyNode scheduleMetrics = Metrics.create();
    private static final PropertyNode executeMetrics = Metrics.create();

    private ThreadPool() {
        this.generalThreadPool = new ScheduledThreadPoolExecutor(Math.max(1, Runtime.getRuntime().availableProcessors() / 2), new ThreadPoolPriorityFactory("GeneralSTPool", 5));
        this.generalThreadPool.allowCoreThreadTimeOut(false);
        this.generalThreadPool.setRemoveOnCancelPolicy(true);
        this.generalThreadPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.purgeTask = this.scheduleGeneralAtFixedRate("ThreadPool.PurgeTask()", new PurgeTask(), 5L, 5L, TimeUnit.MINUTES);
        log.info("ThreadPool initialized:");
        log.info("- GeneralPoolCoreSize: {}/{}", (Object)this.generalThreadPool.getCorePoolSize(), (Object)this.generalThreadPool.getMaximumPoolSize());
    }

    @Nullable
    public ScheduledFuture<?> scheduleGeneral(String name, Runnable task, long delay, TimeUnit unit) {
        if (this.shutdowning.get()) {
            return null;
        }
        try {
            if (EmergencyConfig.ENABLE_METRICS) {
                scheduleMetrics.record(Metrics.happened((String)name));
            }
            return this.generalThreadPool.schedule(new RunnableWrapper(task), delay, unit);
        }
        catch (RejectedExecutionException ignored) {
            return null;
        }
    }

    @Nullable
    public ScheduledFuture<?> scheduleGeneral(String name, Runnable task, @NotNull LocalDateTime dateTime) {
        long deadLine = dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long delay = deadLine - System.currentTimeMillis();
        if (delay > 0L) {
            if (EmergencyConfig.ENABLE_METRICS) {
                scheduleMetrics.record(Metrics.happened((String)name));
            }
            return this.scheduleGeneral(name, task, delay, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    @Nullable
    public ScheduledFuture<?> scheduleGeneralAtFixedRate(String name, Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (this.shutdowning.get()) {
            return null;
        }
        try {
            if (EmergencyConfig.ENABLE_METRICS) {
                scheduleMetrics.record(Metrics.happened((String)name));
            }
            return this.generalThreadPool.scheduleAtFixedRate(new RunnableWrapper(task), initialDelay, period, unit);
        }
        catch (RejectedExecutionException ignored) {
            return null;
        }
    }

    public void executeGeneral(String name, Runnable task) {
        if (this.shutdowning.get()) {
            return;
        }
        try {
            if (EmergencyConfig.ENABLE_METRICS) {
                executeMetrics.record(Metrics.happened((String)name));
            }
            this.generalThreadPool.execute(new RunnableWrapper(task));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @NotNull
    public String getStats() {
        TextStringBuilder builder = new TextStringBuilder();
        builder.appendln(" | -------");
        builder.appendln(" + General:");
        builder.appendln(" |- ActiveThreads:   " + this.generalThreadPool.getActiveCount());
        builder.appendln(" |- getCorePoolSize: " + this.generalThreadPool.getCorePoolSize());
        builder.appendln(" |- PoolSize:        " + this.generalThreadPool.getPoolSize());
        builder.appendln(" |- MaximumPoolSize: " + this.generalThreadPool.getMaximumPoolSize());
        builder.appendln(" |- CompletedTasks:  " + this.generalThreadPool.getCompletedTaskCount());
        builder.appendln(" |- ScheduledTasks:  " + this.generalThreadPool.getQueue().size());
        builder.appendln(" | -------");
        return builder.toString();
    }

    @Override
    public void onShutdown() {
        if (this.shutdowning.compareAndSet(false, true)) {
            try {
                this.purgeTask.cancel(false);
                this.generalThreadPool.shutdown();
                this.generalThreadPool.purge();
                if (!this.generalThreadPool.awaitTermination(120L, TimeUnit.SECONDS)) {
                    this.generalThreadPool.shutdownNow();
                }
                log.info("All ThreadPools are now stopped");
            }
            catch (InterruptedException e) {
                log.warn("There has been a problem shutting down the thread pool manager!", (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public List<MetricResult> getMetric() {
        ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
        MetricResult scheduleResult = new MetricResult();
        scheduleResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        scheduleResult.setName("Schedule");
        scheduleResult.setData((String)scheduleMetrics.render().get());
        metricResults.add(scheduleResult);
        MetricResult executeResult = new MetricResult();
        executeResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        executeResult.setName("Execute");
        executeResult.setData((String)executeMetrics.render().get());
        metricResults.add(executeResult);
        return metricResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ThreadPool getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ThreadPool actualValue = new ThreadPool();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ThreadPool)($value == instance ? null : $value);
    }

    @Generated
    public ScheduledThreadPoolExecutor getGeneralThreadPool() {
        return this.generalThreadPool;
    }

    private class PurgeTask
    implements Runnable {
        private PurgeTask() {
        }

        @Override
        public void run() {
            ThreadPool.this.generalThreadPool.purge();
        }
    }
}

