/*
 * Copyright © 2016 BDO-Emu authors. All rights reserved.
 * Viewing, editing, running and distribution of this software strongly prohibited.
 * Author: xTz, Anton Lasevich, Tibald
 */

package host.anzo.commons.utils;

import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/**
 * @author ANZO
 * @since 9/10/2018
 */
public class LCIDUtils {
	private static final Map<Integer, Locale> lcid2localeMap = new HashMap<>();
	static {
		lcid2localeMap.put(0x0401, parseLocale("ar_SA"));
		lcid2localeMap.put(0x0402, parseLocale("bg_BG"));
		lcid2localeMap.put(0x0403, parseLocale("ca_ES"));
		lcid2localeMap.put(0x0404, parseLocale("zh_TW"));
		lcid2localeMap.put(0x0405, parseLocale("cs_CZ"));
		lcid2localeMap.put(0x0406, parseLocale("da_DK"));
		lcid2localeMap.put(0x0407, parseLocale("de_DE"));
		lcid2localeMap.put(0x0408, parseLocale("el_GR"));
		lcid2localeMap.put(0x0409, parseLocale("en_US"));
		lcid2localeMap.put(0x040a, parseLocale("es_ES"));
		lcid2localeMap.put(0x040b, parseLocale("fi_FI"));
		lcid2localeMap.put(0x040c, parseLocale("fr_FR"));
		lcid2localeMap.put(0x040d, parseLocale("iw_IL"));
		lcid2localeMap.put(0x040e, parseLocale("hu_HU"));
		lcid2localeMap.put(0x040f, parseLocale("is_IS"));
		lcid2localeMap.put(0x0410, parseLocale("it_IT"));
		lcid2localeMap.put(0x0411, parseLocale("ja_JP"));
		lcid2localeMap.put(0x0412, parseLocale("ko_KR"));
		lcid2localeMap.put(0x0413, parseLocale("nl_NL"));
		lcid2localeMap.put(0x0414, parseLocale("no_NO"));
		lcid2localeMap.put(0x0415, parseLocale("pl_PL"));
		lcid2localeMap.put(0x0416, parseLocale("pt_BR"));
		lcid2localeMap.put(0x0417, parseLocale("rm_CH"));
		lcid2localeMap.put(0x0418, parseLocale("ro_RO"));
		lcid2localeMap.put(0x0419, parseLocale("ru_RU"));
		lcid2localeMap.put(0x041a, parseLocale("hr_HR"));
		lcid2localeMap.put(0x041b, parseLocale("sk_SK"));
		lcid2localeMap.put(0x041c, parseLocale("sq_AL"));
		lcid2localeMap.put(0x041d, parseLocale("sv_SE"));
		lcid2localeMap.put(0x041e, parseLocale("th_TH"));
		lcid2localeMap.put(0x041f, parseLocale("tr_TR"));
		lcid2localeMap.put(0x0420, parseLocale("ur_PK"));
		lcid2localeMap.put(0x0421, parseLocale("in_ID"));
		lcid2localeMap.put(0x0422, parseLocale("uk_UA"));
		lcid2localeMap.put(0x0423, parseLocale("be_BY"));
		lcid2localeMap.put(0x0424, parseLocale("sl_SI"));
		lcid2localeMap.put(0x0425, parseLocale("et_EE"));
		lcid2localeMap.put(0x0426, parseLocale("lv_LV"));
		lcid2localeMap.put(0x0427, parseLocale("lt_LT"));
		lcid2localeMap.put(0x0429, parseLocale("fa_IR"));
		lcid2localeMap.put(0x042a, parseLocale("vi_VN"));
		lcid2localeMap.put(0x042b, parseLocale("hy_AM"));
		lcid2localeMap.put(0x042c, parseLocale("az_AZ"));
		lcid2localeMap.put(0x042d, parseLocale("eu_ES"));
		lcid2localeMap.put(0x042f, parseLocale("mk_MK"));
		lcid2localeMap.put(0x0431, parseLocale("ts"));
		lcid2localeMap.put(0x0432, parseLocale("tn_BW"));
		lcid2localeMap.put(0x0434, parseLocale("xh"));
		lcid2localeMap.put(0x0435, parseLocale("zu"));
		lcid2localeMap.put(0x0436, parseLocale("af_ZA"));
		lcid2localeMap.put(0x0437, parseLocale("ka_GE"));
		lcid2localeMap.put(0x0438, parseLocale("fo_FO"));
		lcid2localeMap.put(0x0439, parseLocale("in_IN"));
		lcid2localeMap.put(0x043a, parseLocale("mt_MT"));
		lcid2localeMap.put(0x043c, parseLocale("gd_GB"));
		lcid2localeMap.put(0x043d, parseLocale("yi"));
		lcid2localeMap.put(0x043e, parseLocale("ms_MY"));
		lcid2localeMap.put(0x043f, parseLocale("kk_KZ"));
		lcid2localeMap.put(0x0441, parseLocale("sw_KE"));
		lcid2localeMap.put(0x0443, parseLocale("uz_UZ"));
		lcid2localeMap.put(0x0444, parseLocale("tt"));
		lcid2localeMap.put(0x0449, parseLocale("ta_IN"));
		lcid2localeMap.put(0x044e, parseLocale("mr_IN"));
		lcid2localeMap.put(0x044f, parseLocale("sa_IN"));
		lcid2localeMap.put(0x0801, parseLocale("ar_IQ"));
		lcid2localeMap.put(0x0804, parseLocale("zh_CN"));
		lcid2localeMap.put(0x0807, parseLocale("de_CH"));
		lcid2localeMap.put(0x0809, parseLocale("en_GB"));
		lcid2localeMap.put(0x080a, parseLocale("es_MX"));
		lcid2localeMap.put(0x080c, parseLocale("fr_BE"));
		lcid2localeMap.put(0x0810, parseLocale("it_CH"));
		lcid2localeMap.put(0x0812, parseLocale("ko_KR"));
		lcid2localeMap.put(0x0813, parseLocale("nl_BE"));
		lcid2localeMap.put(0x0814, parseLocale("no_NO_NY"));
		lcid2localeMap.put(0x0816, parseLocale("pt_PT"));
		lcid2localeMap.put(0x0818, parseLocale("ro_MD"));
		lcid2localeMap.put(0x0819, parseLocale("ru_MD"));
		lcid2localeMap.put(0x081a, parseLocale("sh_YU"));
		lcid2localeMap.put(0x081d, parseLocale("sv_FI"));
		lcid2localeMap.put(0x082c, parseLocale("az_AZ"));
		lcid2localeMap.put(0x083c, parseLocale("ga_IE"));
		lcid2localeMap.put(0x083e, parseLocale("ms_BN"));
		lcid2localeMap.put(0x0843, parseLocale("uz_UZ"));
		lcid2localeMap.put(0x0c01, parseLocale("ar_EG"));
		lcid2localeMap.put(0x0c04, parseLocale("zh_HK"));
		lcid2localeMap.put(0x0c07, parseLocale("de_AT"));
		lcid2localeMap.put(0x0c09, parseLocale("en_AU"));
		lcid2localeMap.put(0x0c0a, parseLocale("es_ES"));
		lcid2localeMap.put(0x0c0c, parseLocale("fr_CA"));
		lcid2localeMap.put(0x0c1a, parseLocale("sr_YU"));
		lcid2localeMap.put(0x1001, parseLocale("ar_LY"));
		lcid2localeMap.put(0x1004, parseLocale("zh_SG"));
		lcid2localeMap.put(0x1007, parseLocale("de_LU"));
		lcid2localeMap.put(0x1009, parseLocale("en_CA"));
		lcid2localeMap.put(0x100a, parseLocale("es_GT"));
		lcid2localeMap.put(0x100c, parseLocale("fr_CH"));
		lcid2localeMap.put(0x1401, parseLocale("ar_DZ"));
		lcid2localeMap.put(0x1404, parseLocale("zh_MO"));
		lcid2localeMap.put(0x1407, parseLocale("de_LI"));
		lcid2localeMap.put(0x1409, parseLocale("en_NZ"));
		lcid2localeMap.put(0x140a, parseLocale("es_CR"));
		lcid2localeMap.put(0x140c, parseLocale("fr_LU"));
		lcid2localeMap.put(0x1801, parseLocale("ar_MA"));
		lcid2localeMap.put(0x1809, parseLocale("en_IE"));
		lcid2localeMap.put(0x180a, parseLocale("es_PA"));
		lcid2localeMap.put(0x180c, parseLocale("fr_MC"));
		lcid2localeMap.put(0x1c01, parseLocale("ar_TN"));
		lcid2localeMap.put(0x1c09, parseLocale("en_ZA"));
		lcid2localeMap.put(0x1c0a, parseLocale("es_DO"));
		lcid2localeMap.put(0x2001, parseLocale("ar_OM"));
		lcid2localeMap.put(0x2009, parseLocale("en_JM"));
		lcid2localeMap.put(0x200a, parseLocale("es_VE"));
		lcid2localeMap.put(0x2401, parseLocale("ar_YE"));
		lcid2localeMap.put(0x2409, parseLocale("en"));
		lcid2localeMap.put(0x240a, parseLocale("es_CO"));
		lcid2localeMap.put(0x2801, parseLocale("ar_SY"));
		lcid2localeMap.put(0x2809, parseLocale("en_BZ"));
		lcid2localeMap.put(0x280a, parseLocale("es_PE"));
		lcid2localeMap.put(0x2c01, parseLocale("ar_JO"));
		lcid2localeMap.put(0x2c09, parseLocale("en_TT"));
		lcid2localeMap.put(0x2c0a, parseLocale("es_AR"));
		lcid2localeMap.put(0x3001, parseLocale("ar_LB"));
		lcid2localeMap.put(0x3009, parseLocale("en_ZW"));
		lcid2localeMap.put(0x300a, parseLocale("es_EC"));
		lcid2localeMap.put(0x3401, parseLocale("ar_KW"));
		lcid2localeMap.put(0x3409, parseLocale("en_PH"));
		lcid2localeMap.put(0x340a, parseLocale("es_CL"));
		lcid2localeMap.put(0x3801, parseLocale("ar_AE"));
		lcid2localeMap.put(0x380a, parseLocale("es_UY"));
		lcid2localeMap.put(0x3c01, parseLocale("ar_BH"));
		lcid2localeMap.put(0x3c0a, parseLocale("es_PY"));
		lcid2localeMap.put(0x4001, parseLocale("ar_QA"));
		lcid2localeMap.put(0x400a, parseLocale("es_BO"));
		lcid2localeMap.put(0x440a, parseLocale("es_SV"));
		lcid2localeMap.put(0x480a, parseLocale("es_HN"));
		lcid2localeMap.put(0x4c0a, parseLocale("es_NI"));
		lcid2localeMap.put(0x500a, parseLocale("es_PR"));
	}

	private static @NotNull Locale parseLocale(String lcv) {
		final StringTokenizer t = new StringTokenizer(lcv, "_");
		final Locale.Builder builder = new Locale.Builder();
		builder.setLanguage(t.nextToken().toLowerCase());
		builder.setRegion(t.hasMoreTokens() ? t.nextToken().toUpperCase() : "");
		builder.setVariant(t.hasMoreTokens() ? t.nextToken() : "");
		return builder.build();
	}

	public static synchronized Locale lcid2locale(int lcid, Locale defLocale) {
		return lcid2localeMap.getOrDefault(lcid, defLocale);
	}
}