/*
 * Copyright © 2016 BDO-Emu authors. All rights reserved.
 * Viewing, editing, running and distribution of this software strongly prohibited.
 * Author: xTz, Anton Lasevich, Tibald
 */

package host.anzo.commons.utils;

import org.jetbrains.annotations.NotNull;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/***
 * @author ANZO
 */
public class StreamUtils {
    public static List<Integer> closedRange(int startInclusive, int endInclusive) {
        return IntStream.rangeClosed(startInclusive, endInclusive)
                .boxed()
                .collect(Collectors.toList());
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortMapByValue(@NotNull Map<K, V> map, boolean isReverseOrder) {
        return map.entrySet().stream()
                .sorted(isReverseOrder ? Map.Entry.comparingByValue(Comparator.reverseOrder()) : Map.Entry.comparingByValue(Comparator.naturalOrder()))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }
}