/*
 * Copyright © 2016 BDO-Emu authors. All rights reserved.
 * Viewing, editing, running and distribution of this software strongly prohibited.
 * Author: xTz, Anton Lasevich, Tibald
 */

package host.anzo.commons.utils;

import org.jetbrains.annotations.NotNull;

/***
 * @author ANZO
 * @since 2/6/2023
 */
public class StringExUtils {
    /***
     * Remove all whitespaces/tabs and special symbols like   and ‬
     * @param input input string
     * @return trim string
     */
    public static @NotNull String trimNBSP(@NotNull String input) {
        return input.trim().replaceAll("\u00A0", "").replaceAll("\u202C", "");
    }
}