/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import org.jetbrains.annotations.Nullable;

public class HotSpotUtils {
    private static HotSpotDiagnosticMXBean hotspotDiagnosticBean;

    public static HotSpotDiagnosticMXBean getBean() {
        return hotspotDiagnosticBean;
    }

    public static VMOption getVMOption(String optionName) {
        return hotspotDiagnosticBean.getVMOption(optionName);
    }

    public static long getDirectBufferFreeMemory() {
        BufferPoolMXBean bufferPool = HotSpotUtils.getByteBufferPool(true);
        if (bufferPool != null) {
            return Long.parseLong(HotSpotUtils.getVMOption("MaxDirectMemorySize").getValue()) - bufferPool.getMemoryUsed();
        }
        return -1L;
    }

    @Nullable
    public static BufferPoolMXBean getByteBufferPool(boolean isDirect) {
        List<BufferPoolMXBean> pools = HotSpotUtils.getByteBufferPools();
        Iterator<BufferPoolMXBean> iterator = pools.iterator();
        if (iterator.hasNext()) {
            BufferPoolMXBean pool = iterator.next();
            if (isDirect && pool.getName().equals("direct")) {
                return pool;
            }
            return pool;
        }
        return null;
    }

    public static List<BufferPoolMXBean> getByteBufferPools() {
        return ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    }

    private static HotSpotDiagnosticMXBean getHotspotDiagnosticBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<HotSpotUtils> clazz = HotSpotUtils.class;
        synchronized (HotSpotUtils.class) {
            if (hotspotDiagnosticBean == null) {
                hotspotDiagnosticBean = HotSpotUtils.getHotspotDiagnosticBean();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

