/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    public static FileSystem createZipFileSystem(String zipFilename, boolean create) throws IOException {
        Path path = Paths.get(zipFilename, new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath().replace(" ", "%20"));
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public static void putFileToZipStream(String fileName, ZipOutputStream zos) {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                zos.putNextEntry(new ZipEntry(new File(fileName).getName()));
                byte[] bytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
                zos.write(bytes, 0, bytes.length);
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            log.error("Error while putFileToZipStream() fileName=[{}]", (Object)fileName, (Object)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(bos);){
                gzip.write(data);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            log.error("Error while compress data", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompress(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
            byte[] byArray;
            try (GZIPInputStream gis = new GZIPInputStream(bis);){
                byArray = IOUtils.toByteArray((InputStream)gis);
            }
            return byArray;
        }
        catch (IOException e) {
            log.error("Error while decompress data", (Throwable)e);
            return null;
        }
    }
}

