/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.xml;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlBuilder.class);
    private final String name;
    private final Object value;
    private final XmlBuilder parent;
    private final String comment;
    private final LinkedHashMap<String, String> attributes = new LinkedHashMap();
    private final LinkedList<XmlBuilder> childNodes = new LinkedList();

    public XmlBuilder(String rootName) {
        this.name = rootName;
        this.value = null;
        this.parent = null;
        this.comment = null;
    }

    protected XmlBuilder(String name, Object value, XmlBuilder parent, String comment) {
        this.name = name;
        this.value = value;
        this.parent = parent;
        this.comment = comment;
    }

    public XmlBuilder e(String name) {
        return this.e(name, null, null);
    }

    public XmlBuilder e(String name, String comment) {
        return this.e(name, null, comment);
    }

    public XmlBuilder e(String name, Object value, String comment) {
        XmlBuilder node = new XmlBuilder(name, value, this, comment);
        this.childNodes.add(node);
        return node;
    }

    public XmlBuilder a(String name, @NotNull Object value) {
        this.attributes.put(name, value.toString());
        return this;
    }

    public String toString() {
        return this.getString(0);
    }

    protected String getString(int tabCount) {
        TextStringBuilder builder = new TextStringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.comment)) {
            builder.append(StringUtils.repeat((String)"\t", (int)tabCount)).append("<!-- ").append(this.comment).appendln(" -->");
        }
        builder.append(StringUtils.repeat((String)"\t", (int)tabCount)).append("<").append(this.name);
        if (!this.attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                builder.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
            }
        }
        if (this.value == null && this.childNodes.isEmpty()) {
            builder.appendln("/>");
        } else {
            builder.appendln(">");
            ++tabCount;
            if (this.value != null) {
                builder.append(StringUtils.repeat((String)"\t", (int)tabCount)).appendln(this.value);
            } else if (!this.childNodes.isEmpty()) {
                for (XmlBuilder node : this.childNodes) {
                    builder.append(node.getString(tabCount));
                }
            }
            builder.append(StringUtils.repeat((String)"\t", (int)(--tabCount))).appendln("</" + this.name + ">");
        }
        return builder.toString();
    }

    public void writeToFile(File file) {
        try {
            FileUtils.writeStringToFile((File)file, (String)this.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Error writing XmlBuilder string result to file=[{}]", (Object)file, (Object)e);
        }
    }

    public void writeToFile(String filePath) {
        try {
            FileUtils.writeStringToFile((File)new File(filePath), (String)this.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Error writing XmlBuilder string result to file=[{}]", (Object)filePath, (Object)e);
        }
    }
}

