/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.commons.xml.XmlParser;
import host.anzo.core.startup.StartupComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class ObsceneFilterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObsceneFilterService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final List<ObsceneData> obsceneList = new ArrayList<ObsceneData>();
    private static final List<String> badWordsCache = new ArrayList<String>();

    private ObsceneFilterService() {
        try {
            try (XmlParser parser = XmlParser.fromResource("obsence_filter/obscene_filter_en.xml", this.getClass().getClassLoader());){
                obsceneList.add(new ObsceneData(parser));
            }
            parser = XmlParser.fromResource("obsence_filter/obscene_filter_ru.xml", this.getClass().getClassLoader());
            try {
                obsceneList.add(new ObsceneData(parser));
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
            log.info("Loaded obscene filters for [{}] locales.", (Object)obsceneList.size());
        }
        catch (Exception e) {
            log.error("Error while ObsceneFilterService initializing", (Throwable)e);
        }
    }

    public String filterWord(@NotNull String inputString) {
        String outputString = inputString;
        for (String word : inputString.split(" ")) {
            for (ObsceneData obscene : obsceneList) {
                if (!obscene.isApplicable(word) || !this.isObsceneWord(word)) continue;
                outputString = outputString.replace(word, StringUtils.repeat((String)"*", (int)word.length()));
            }
        }
        return outputString;
    }

    public boolean isObsceneWord(String word) {
        for (ObsceneData obscene : obsceneList) {
            if (!this.isObsceneWord(word, obscene)) continue;
            return true;
        }
        return false;
    }

    private boolean isObsceneWord(String word, ObsceneData obscene) {
        if (badWordsCache.contains(word)) {
            return true;
        }
        if (obscene.getPattern().matcher(word).find() && obscene.isObsceneWord(word)) {
            badWordsCache.add(word);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ObsceneFilterService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ObsceneFilterService actualValue = new ObsceneFilterService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ObsceneFilterService)($value == instance ? null : $value);
    }

    public static class ObsceneData {
        private final EObsceneLocaleType locale;
        private final Pattern pattern;
        private final Map<String, String> equivalents = new HashMap<String, String>();
        private final List<ObsceneBadWordSet> badWordSet = new ArrayList<ObsceneBadWordSet>();

        public ObsceneData(@NotNull XmlParser node) {
            this.locale = EObsceneLocaleType.valueOf(node.readS("locale"));
            this.pattern = Pattern.compile(node.readS("matcher"));
            block16: for (XmlParser childParser : node.children()) {
                switch (childParser.name()) {
                    case "equivalents": {
                        for (XmlParser eqParser : childParser.children("equivalent")) {
                            String find = eqParser.optChild("find").content().trim();
                            String replace = eqParser.optChild("replace").content().trim();
                            this.equivalents.put(find, replace);
                        }
                        continue block16;
                    }
                    case "badWords": {
                        for (XmlParser bwParser : childParser.children("badWordSet")) {
                            if (bwParser.children("include").isEmpty() && bwParser.children("exclude").isEmpty()) {
                                ObsceneBadWordSet badWord = new ObsceneBadWordSet(Pattern.compile(bwParser.content().trim()), Collections.emptyList());
                                this.badWordSet.add(badWord);
                                continue;
                            }
                            Pattern include = null;
                            ArrayList<Pattern> excludes = new ArrayList<Pattern>();
                            for (XmlParser inExParser : bwParser.children()) {
                                switch (inExParser.name()) {
                                    case "include": {
                                        include = Pattern.compile(inExParser.content().trim());
                                        break;
                                    }
                                    case "exclude": {
                                        excludes.add(Pattern.compile(inExParser.content().trim()));
                                    }
                                }
                            }
                            if (include == null) continue;
                            ObsceneBadWordSet badWord = new ObsceneBadWordSet(include, excludes);
                            this.badWordSet.add(badWord);
                        }
                        break;
                    }
                }
            }
        }

        public EObsceneLocaleType getLocale() {
            return this.locale;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public boolean isApplicable(String input) {
            return this.pattern.matcher(input).find();
        }

        private String replaceWithEquivalents(String word) {
            for (Map.Entry<String, String> entry : this.equivalents.entrySet()) {
                if (!word.contains(entry.getKey())) continue;
                word = word.replace(entry.getKey(), entry.getValue());
            }
            return word;
        }

        public boolean isObsceneWord(String word) {
            word = this.replaceWithEquivalents(word);
            for (ObsceneBadWordSet bw : this.badWordSet) {
                List<Pattern> excludes;
                if (!bw.include().matcher(word).matches() || (excludes = bw.excludes()).isEmpty()) continue;
                for (Pattern exclude : excludes) {
                    if (exclude.matcher(word).matches()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public record ObsceneBadWordSet(Pattern include, List<Pattern> excludes) {
    }

    public static enum EObsceneLocaleType {
        EN,
        RU;

    }
}

