package host.anzo.core.startup;

import host.anzo.commons.threading.ThreadPool;
import host.anzo.commons.utils.ClassUtils;

import java.util.*;

/**
 * @author ANZO
 * @since 27.12.2016
 */
public interface IStartupLevel {
	Map<IStartupLevel, List<StartupMethodInfo>> beforeMethods = new HashMap<>();
	Map<IStartupLevel, List<StartupMethodInfo>> afterMethods = new HashMap<>();

	default void before() {}
	default void after() {}

	default void addBefore(StartupMethodInfo methodInfo) {
		beforeMethods.computeIfAbsent(this, k -> new ArrayList<>()).add(methodInfo);
	}

	default void addAfter(StartupMethodInfo methodInfo) {
		afterMethods.computeIfAbsent(this, k -> new ArrayList<>()).add(methodInfo);
	}

	default void runBeforeMethods() {
		for (StartupMethodInfo methodInfo : beforeMethods.getOrDefault(this, Collections.emptyList())) {
			if (methodInfo.isAsync()) {
				ThreadPool.getInstance().executeGeneral("StartupInstance.runBeforeMethods()", () -> ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method()));
			}
			else {
				ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method());
			}
		}
	}

	default void runAfterMethods() {
		for (StartupMethodInfo methodInfo : afterMethods.getOrDefault(this, Collections.emptyList())) {
			if (methodInfo.isAsync()) {
				ThreadPool.getInstance().executeGeneral("StartupInstance.runAfterMethods()", () -> ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method()));
			}
			else {
				ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method());
			}
		}
	}
}