/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import com.google.common.util.concurrent.RateLimiter;
import host.anzo.commons.model.enums.EFirewallType;
import host.anzo.commons.model.enums.ERestrictionType;
import host.anzo.commons.utils.DateTimeUtils;
import host.anzo.commons.utils.NetworkUtils;
import host.anzo.commons.utils.VMUtils;
import host.anzo.core.config.FirewallConfig;
import host.anzo.core.startup.Scheduled;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirewallService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"Firewall");
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, Long> blockedIps = new ConcurrentHashMap<String, Long>();
    private final Map<String, Map<String, RateLimiter>> connectionRateLimiters = new ConcurrentHashMap<String, Map<String, RateLimiter>>();

    private FirewallService() {
        this.flushSystemFirewall();
    }

    public boolean isAllowedAddress(Class<?> clazz, String ip, int destPort, double allowedRequestsPerSecond, ERestrictionType restrictionType) {
        return this.isAllowedAddress(clazz.getSimpleName(), ip, destPort, allowedRequestsPerSecond, restrictionType);
    }

    public boolean isAllowedAddress(String className, String ip, int destPort, double allowedRequestsPerSecond, ERestrictionType restrictionType) {
        if (!VMUtils.DEBUG) {
            try {
                if (NetworkUtils.isLocalAddress(InetAddress.getByName(ip))) {
                    return true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (this.blockedIps.containsKey(ip)) {
            return false;
        }
        Map classLimiters = this.connectionRateLimiters.computeIfAbsent(className, k -> new ConcurrentHashMap());
        RateLimiter ipLimiter = classLimiters.computeIfAbsent(ip, k -> RateLimiter.create((double)allowedRequestsPerSecond));
        if (!ipLimiter.tryAcquire()) {
            if (restrictionType == ERestrictionType.BAN) {
                this.addBlock(className, ip, destPort, FirewallConfig.FIREWALL_BAN_TIME, TimeUnit.MILLISECONDS);
            }
            classLimiters.remove(ip);
            return false;
        }
        return true;
    }

    public void addBlock(String className, String ip, int destPort, long banTime, TimeUnit banTimeUnit) {
        long unban_time = 0L;
        if (FirewallConfig.FIREWALL_TYPE == EFirewallType.SYSTEM && SystemUtils.IS_OS_LINUX) {
            String firewallCommand = FirewallConfig.FIREWALL_SYSTEM_FIREWALL_RULE.replace("$ip", ip);
            try {
                Runtime.getRuntime().exec(firewallCommand.split(" "));
                unban_time = -1L;
            }
            catch (IOException e) {
                log.error("Error while adding firewall rule for class=[{}] and ipAddress=[{}]", new Object[]{className, ip, e});
            }
        } else if (FirewallConfig.FIREWALL_TYPE == EFirewallType.INTERNAL) {
            unban_time = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(banTime, banTimeUnit);
            this.blockedIps.put(ip, unban_time);
        }
        if (unban_time != 0L) {
            if (unban_time > 0L) {
                log.error("Address ip=[{}] blocked by [{}] firewall at port [{}] for [{}]", new Object[]{ip, className, destPort, DateTimeUtils.getLocalDateTime(unban_time).format(DateTimeFormatter.ISO_LOCAL_DATE)});
            } else {
                log.error("Address ip=[{}] blocked by [{}] firewall at port [{}] permanently", new Object[]{ip, className, destPort});
            }
        }
    }

    public void removeBlock(String ipAddress) {
        this.blockedIps.remove(ipAddress);
    }

    public void clear() {
        this.blockedIps.clear();
    }

    public void flushSystemFirewall() {
        if (FirewallConfig.FIREWALL_TYPE == EFirewallType.SYSTEM && SystemUtils.IS_OS_LINUX) {
            for (String set : FirewallConfig.FIREWALL_FLUSHED_SETS_BEFORE_START) {
                String firewallCommand = "nft flush set inet filter " + set;
                try {
                    Runtime.getRuntime().exec(firewallCommand.split(" "));
                }
                catch (IOException e) {
                    log.error("Error while flushing firewall set [{}]", (Object)set, (Object)e);
                }
            }
        }
    }

    @Scheduled(period=1L, timeUnit=TimeUnit.MINUTES, runAfterServerStart=true)
    public void cleanupBans() {
        for (Map.Entry<String, Long> entry : this.blockedIps.entrySet()) {
            if (entry.getValue() >= System.currentTimeMillis()) continue;
            this.blockedIps.remove(entry.getKey());
        }
        this.connectionRateLimiters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static FirewallService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    FirewallService actualValue = new FirewallService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (FirewallService)($value == instance ? null : $value);
    }
}

