/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.commons.model.enums.EHttpRequestContentType;
import host.anzo.core.config.WebServerConfig;
import host.anzo.core.startup.StartupComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class HttpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static AntiSamy antiSamy;

    private HttpService() {
        try (InputStream ruleInputStream = this.getClass().getClassLoader().getResourceAsStream("antisamy-slashdot.xml");){
            if (ruleInputStream != null) {
                antiSamy = new AntiSamy(Policy.getInstance((InputStream)ruleInputStream));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading antisamy rules", e);
        }
        if (WebServerConfig.IGNORE_SSL_CERTIFICATE_ERRORS) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                HostnameVerifier hv = (urlHostName, session) -> {
                    if (!urlHostName.equalsIgnoreCase(session.getPeerHost())) {
                        log.warn("URL host '{}' is different to SSLSession host '{}'.", (Object)urlHostName, (Object)session.getPeerHost());
                    }
                    return true;
                };
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            }
            catch (Exception e) {
                log.error("Can't override default hostname verifier due error", (Throwable)e);
            }
        }
    }

    public String stripXSS(String input) {
        try {
            return antiSamy.scan(input).getCleanHTML();
        }
        catch (PolicyException | ScanException e) {
            return "";
        }
    }

    public String httpGet(String urlString) {
        return this.httpGet(urlString, null);
    }

    public String httpGet(@NotNull String urlString, Map<String, String> headers) {
        if (urlString.startsWith("https")) {
            String string;
            block21: {
                SSLContext sslContext2 = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
                CloseableHttpClient client = HttpClients.custom().setSSLContext(sslContext2).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
                try {
                    HttpGet httpGet = new HttpGet(urlString);
                    if (headers != null) {
                        for (Map.Entry<String, String> entry : headers.entrySet()) {
                            httpGet.addHeader(entry.getKey(), entry.getValue());
                        }
                    }
                    CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
                    HttpEntity entity = response.getEntity();
                    string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    if (client == null) break block21;
                }
                catch (Throwable httpGet) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable response) {
                                httpGet.addSuppressed(response);
                            }
                        }
                        throw httpGet;
                    }
                    catch (SocketTimeoutException | SSLHandshakeException | HttpHostConnectException sslContext2) {
                    }
                    catch (Exception e) {
                        log.error("Fatal transport error", (Throwable)e);
                    }
                }
                client.close();
            }
            return string;
        } else {
            String string;
            block22: {
                CloseableHttpClient client = HttpClients.createDefault();
                try {
                    HttpGet httpGet = new HttpGet(urlString);
                    CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
                    HttpEntity entity = response.getEntity();
                    string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    if (client == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error("Fatal transport error", (Throwable)e);
                    }
                }
                client.close();
            }
            return string;
        }
        return null;
    }

    public String httpPost(String urlString, @NotNull String postData) {
        return this.httpPost(urlString, postData, null, EHttpRequestContentType.FormUrlEncoded);
    }

    public String httpPost(String urlString, String postData, Map<String, String> headers, @NotNull EHttpRequestContentType requestContentType) {
        String string;
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("charset", "UTF-8");
        connection.setRequestProperty("Content-Type", requestContentType.getTextValue());
        connection.setDoOutput(true);
        connection.setDoInput(true);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (postData != null) {
            try (OutputStream out = connection.getOutputStream();){
                out.write(postData.getBytes());
            }
            catch (Exception e) {
                log.error("Error while writing postData=[{}] to url=[{}]", new Object[]{postData, urlString, e});
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static HttpService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    HttpService actualValue = new HttpService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (HttpService)($value == instance ? null : $value);
    }
}

