/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.startup;

import host.anzo.commons.threading.ThreadPool;
import host.anzo.commons.utils.ClassUtils;
import host.anzo.core.service.ForkJoinPoolService;
import host.anzo.core.startup.EShutdownPriority;
import host.anzo.core.startup.IShutdownable;
import host.anzo.core.startup.Scheduled;
import host.anzo.core.startup.StartupComponent;
import host.anzo.core.startup.StartupRun;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="AfterStart", shutdownPriority=EShutdownPriority.MAJOR)
public class ScheduledService
implements IShutdownable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final List<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
    private final Map<Class<?>, List<ScheduledTask>> scheduledTasks = new HashMap();

    private ScheduledService() {
    }

    @StartupRun(before="AfterStart")
    public void scheduleTasks() {
        log.info("Running Scheduled methods after server start...");
        ForkJoinPoolService.getInstance().forEach("ScheduledService.runAfterServerStart()", () -> this.tasks.parallelStream().filter(task -> task.getMethod().getAnnotation(Scheduled.class).runAfterServerStart()).forEach(ScheduledTask::run));
        log.info("Scheduling Scheduled methods tasks...");
        for (ScheduledTask task : this.tasks) {
            Scheduled scheduledAnnotation = task.getMethod().getAnnotation(Scheduled.class);
            TimeUnit timeUnit = scheduledAnnotation.timeUnit();
            long period = scheduledAnnotation.period();
            if (TimeUnit.MILLISECONDS.convert(period, timeUnit) <= 0L) {
                log.error("Delay is zero for scheduled task {}.{}", (Object)task.getServiceClass().getSimpleName(), (Object)task.getMethod().getName());
                continue;
            }
            ScheduledFuture<?> scheduledFuture = ThreadPool.getInstance().scheduleGeneralAtFixedRate(task.getServiceClass().getSimpleName() + "." + task.getMethod().getName(), task, period, period, timeUnit);
            task.setScheduledFuture(scheduledFuture);
            this.scheduledTasks.computeIfAbsent(task.getServiceClass(), k -> new ArrayList()).add(task);
        }
    }

    protected void addScheduledMethod(@NotNull Class<?> serviceClass, @NotNull Method method) {
        if (method.isAnnotationPresent(Scheduled.class)) {
            this.tasks.add(new ScheduledTask(serviceClass, method));
        }
    }

    @Override
    public void onShutdown() {
        for (List<ScheduledTask> scheduledTasks : this.scheduledTasks.values()) {
            for (ScheduledTask scheduledTask : scheduledTasks) {
                try {
                    scheduledTask.getScheduledFuture().cancel(true);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ScheduledService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ScheduledService actualValue = new ScheduledService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ScheduledService)($value == instance ? null : $value);
    }

    private static class ScheduledTask
    implements Runnable {
        private final Class<?> serviceClass;
        private final Method method;
        private ScheduledFuture<?> scheduledFuture;

        ScheduledTask(@NotNull Class<?> serviceClass, @NotNull Method method) {
            this.serviceClass = serviceClass;
            this.method = method;
        }

        @Override
        public void run() {
            try {
                ClassUtils.singletonInstanceMethod(this.serviceClass, this.method);
            }
            catch (Exception e) {
                log.error("Error while calling scheduled task at {}.{}", new Object[]{this.serviceClass.getSimpleName(), this.method.getName(), e});
            }
        }

        @Generated
        public Class<?> getServiceClass() {
            return this.serviceClass;
        }

        @Generated
        public Method getMethod() {
            return this.method;
        }

        @Generated
        public ScheduledFuture<?> getScheduledFuture() {
            return this.scheduledFuture;
        }

        @Generated
        public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }
    }
}

