/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.webserver;

import com.google.gson.Gson;
import de.mxro.metrics.jre.Metrics;
import delight.async.properties.PropertyNode;
import host.anzo.classindex.ClassIndex;
import host.anzo.commons.concurrent.CloseableReentrantLock;
import host.anzo.commons.emergency.metric.IMetric;
import host.anzo.commons.emergency.metric.Metric;
import host.anzo.commons.emergency.metric.MetricGroupType;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.commons.model.enums.ERestrictionType;
import host.anzo.commons.utils.ConsoleUtils;
import host.anzo.commons.utils.VMUtils;
import host.anzo.core.config.EmergencyConfig;
import host.anzo.core.config.WebServerConfig;
import host.anzo.core.service.FirewallService;
import host.anzo.core.service.HttpService;
import host.anzo.core.startup.StartupComponent;
import host.anzo.core.webserver.engine.ThymeleafTemplateEngine;
import host.anzo.core.webserver.model.AWebArea;
import host.anzo.core.webserver.model.WebArea;
import host.anzo.core.webserver.model.WebSocketsArea;
import host.anzo.core.webserver.model.captcha.ReCaptchaResponse;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.jakarta.JakartaServletDiskFileUpload;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;

@Metric
@StartupComponent(value="AfterStart")
public class WebService
implements IMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private ThymeleafTemplateEngine templateEngine;
    private JakartaServletFileUpload<DiskFileItem, DiskFileItemFactory> fileUploadServlet;
    private static final PropertyNode webMetrics = Metrics.create();
    private static final Gson gson = new Gson();
    private final ConcurrentHashMap<Long, CloseableReentrantLock> lockersMap = new ConcurrentHashMap();

    private WebService() {
        ConsoleUtils.printSection("WebService Loading");
        if (WebServerConfig.ENABLE) {
            if (WebServerConfig.USE_FIDDLER_PROXY) {
                System.setProperty("http.proxyHost", "127.0.0.1");
                System.setProperty("https.proxyHost", "127.0.0.1");
                System.setProperty("http.proxyPort", "18888");
                System.setProperty("https.proxyPort", "18888");
                System.setProperty("javax.net.ssl.trustStoreType", "Windows-ROOT");
            }
            this.templateEngine = new ThymeleafTemplateEngine();
            this.fileUploadServlet = new JakartaServletDiskFileUpload();
            this.init();
        } else {
            log.info("Embedded webserver disabled due config.");
        }
    }

    private void init() {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{WebServerConfig.DATA_PATH})) {
            if (!Files.isDirectory(Paths.get(WebServerConfig.DATA_PATH, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("Can't find specified web static files directory: " + WebServerConfig.DATA_PATH);
            }
            Spark.staticFiles.externalLocation(WebServerConfig.DATA_PATH);
        } else {
            log.info("Web server static files folder not defined. Ignoring.");
        }
        if (!WebServerConfig.DEBUG && !VMUtils.DEBUG) {
            Spark.staticFiles.expireTime(600L);
        }
        if (WebServerConfig.ALLOW_ONLY_CLOUDFLARE_IPS) {
            Spark.untrustForwardHeaders();
        }
        Spark.port((int)WebServerConfig.PORT);
        if (WebServerConfig.ENABLE_SOCKETS) {
            for (Class webSocketAreaClass : ClassIndex.getAnnotated(WebSocketsArea.class)) {
                WebSocketsArea webSocketsAreaAnnotation = webSocketAreaClass.getAnnotation(WebSocketsArea.class);
                Spark.webSocket((String)webSocketsAreaAnnotation.path(), (Class)webSocketAreaClass);
                log.info("Registered [{}] web sockets area at path [{}]", (Object)webSocketAreaClass.getSimpleName(), (Object)webSocketsAreaAnnotation.path());
            }
        }
        if (WebServerConfig.ENABLE_SSL) {
            try {
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream jksInputStream = new FileInputStream(WebServerConfig.SSL_STORE_PATH);){
                    keystore.load(jksInputStream, WebServerConfig.SSL_STORE_PASSWORD.toCharArray());
                    Enumeration<String> aliases = keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        String aliasName = aliases.nextElement();
                        Date certExpiryDate = ((X509Certificate)keystore.getCertificate(aliasName)).getNotAfter();
                        long dateDiff = certExpiryDate.getTime() - new Date().getTime();
                        long expiresIn = dateDiff / TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
                        if (expiresIn <= 0L) {
                            throw new RuntimeException("Certificate for alias [" + aliasName + "] is expired (valid until [" + certExpiryDate + "])");
                        }
                        if (expiresIn > 30L) {
                            log.info("Loaded certificate for alias [{}] with expire date [{}]", (Object)aliasName, (Object)certExpiryDate);
                            continue;
                        }
                        log.warn("Certificate for alias [{}] will expire on [{}] ({} days left)", new Object[]{aliasName, certExpiryDate, expiresIn});
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while loading web certificate", (Throwable)e);
            }
            Spark.secure((String)WebServerConfig.SSL_STORE_PATH, (String)WebServerConfig.SSL_STORE_PASSWORD, null, null);
        }
        Spark.threadPool((int)WebServerConfig.THREAD_COUNT_MAX, (int)WebServerConfig.THREAD_COUNT_MIN, (int)WebServerConfig.TIMEOUT);
        for (Class webAreaClass : ClassIndex.getAnnotated(WebArea.class)) {
            try {
                AWebArea webArea = (AWebArea)webAreaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                webArea.registerPaths();
                log.info("Registered [{}] web area", (Object)webAreaClass.getSimpleName());
            }
            catch (Exception e) {
                log.error("Error while registering web area [{}]", (Object)webAreaClass.getSimpleName(), (Object)e);
            }
        }
        Spark.awaitInitialization();
    }

    public void onRequest(boolean authentificated) {
        if (EmergencyConfig.ENABLE_METRICS) {
            webMetrics.record(Metrics.increment((String)(authentificated ? "authentificated" : "non-authentificated")));
        }
    }

    public boolean isAllowedAddress(String ip) {
        if (!WebServerConfig.ENABLE_REQUEST_LIMITER) {
            return true;
        }
        return FirewallService.getInstance().isAllowedAddress(WebService.class, ip, WebServerConfig.PORT, (double)WebServerConfig.MAX_REQUESTS_PER_SECOND, ERestrictionType.BAN);
    }

    public CloseableReentrantLock getLock(long userNo) {
        return this.lockersMap.computeIfAbsent(userNo, newLock -> new CloseableReentrantLock());
    }

    public String createReCaptcha() {
        if (!WebServerConfig.RECAPTCHA_ENABLE) {
            return "<div><div/>";
        }
        return "<div align=\"center\" class=\"g-recaptcha\" data-sitekey=\"" + WebServerConfig.RECAPTCHA_PUBLIC_KEY + "\"></div>";
    }

    public ReCaptchaResponse checkReCaptchaAnswer(String remoteIp, String response) {
        if (!WebServerConfig.RECAPTCHA_ENABLE) {
            return null;
        }
        String postParameters = "secret=" + URLEncoder.encode(WebServerConfig.RECAPTCHA_PRIVATE_KEY) + "&remoteip=" + URLEncoder.encode(remoteIp) + "&response=" + URLEncoder.encode(response);
        String message = HttpService.getInstance().httpPost("https://www.google.com/recaptcha/api/siteverify", postParameters);
        if (message == null) {
            return new ReCaptchaResponse(false);
        }
        return (ReCaptchaResponse)gson.fromJson(message, ReCaptchaResponse.class);
    }

    @Override
    public List<MetricResult> getMetric() {
        MetricResult result = new MetricResult();
        result.setMetricGroupType(MetricGroupType.WEB);
        result.setName("WebServiceRequests");
        result.setData((String)webMetrics.render().get());
        return Collections.singletonList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static WebService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    WebService actualValue = new WebService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (WebService)($value == instance ? null : $value);
    }

    @Generated
    public ThymeleafTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Generated
    public JakartaServletFileUpload<DiskFileItem, DiskFileItemFactory> getFileUploadServlet() {
        return this.fileUploadServlet;
    }
}

