/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.text;

import host.anzo.commons.utils.Rnd;
import host.anzo.core.startup.StartupComponent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class RandomNameGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RandomNameGenerator.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final List<String> nouns;
    private final List<String> adjectives = this.load("name_generator/adjectives.txt");
    private final int prime;
    private int currentSeed;

    private RandomNameGenerator() {
        int primeCombo;
        int nextPrime;
        this.nouns = this.load("name_generator/nouns.txt");
        int combo = this.size();
        for (primeCombo = 2; primeCombo <= combo; primeCombo *= nextPrime) {
            nextPrime = primeCombo + 1;
        }
        this.prime = primeCombo + 1;
        this.currentSeed = (int)System.currentTimeMillis();
        log.info("Loaded [{}] words to dictionary.", (Object)this.size());
    }

    @NotNull
    private List<String> load(String name) {
        ArrayList<String> list = new ArrayList<String>();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);
             InputStreamReader streamReader = new InputStreamReader(Objects.requireNonNull(inputStream));
             BufferedReader reader = new BufferedReader(streamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (Exception e) {
            log.error("Error while loading {}", (Object)name, (Object)e);
        }
        return list;
    }

    public int size() {
        return this.nouns.size() * this.adjectives.size();
    }

    public synchronized String getName() {
        this.currentSeed = Math.abs(this.currentSeed + this.prime) % this.size();
        int a = this.currentSeed % this.adjectives.size();
        int n = this.currentSeed / this.adjectives.size();
        return StringUtils.capitalize((String)this.adjectives.get(a)) + StringUtils.capitalize((String)this.nouns.get(n)) + Rnd.get(1, 999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static RandomNameGenerator getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    RandomNameGenerator actualValue = new RandomNameGenerator();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (RandomNameGenerator)($value == instance ? null : $value);
    }
}

