/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.text.formatters;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class RoundedMetricPrefixFormat
extends Format {
    private static final String[] METRIC_PREFIXES = new String[]{"", "k", "M", "G", "T"};
    private static final Integer MAX_LENGTH = 4;
    private static final Pattern TRAILING_DECIMAL_POINT = Pattern.compile("[0-9]+\\.[kMGT]");
    private static final Pattern METRIC_PREFIXED_NUMBER = Pattern.compile("\\-?[0-9]+(\\.[0-9])?[kMGT]");

    @Override
    public StringBuffer format(@NotNull Object obj, @NotNull StringBuffer output, @NotNull FieldPosition pos) {
        Double number = Double.valueOf(obj.toString());
        boolean isNegative = number < 0.0;
        number = Math.abs(number);
        Object result = new DecimalFormat("##0E0").format(number);
        Integer index = Character.getNumericValue(((String)result).charAt(((String)result).length() - 1)) / 3;
        result = ((String)result).replaceAll("E[0-9]", METRIC_PREFIXES[index]);
        while (((String)result).length() > MAX_LENGTH || TRAILING_DECIMAL_POINT.matcher((CharSequence)result).matches()) {
            int length = ((String)result).length();
            result = ((String)result).substring(0, length - 2) + ((String)result).substring(length - 1);
        }
        return output.append((String)(isNegative ? "-" + (String)result : result));
    }

    @Override
    public Object parseObject(String source, @NotNull ParsePosition pos) {
        if (NumberUtils.isCreatable((String)source)) {
            pos.setIndex(source.length());
            return RoundedMetricPrefixFormat.toNumber(source);
        }
        if (METRIC_PREFIXED_NUMBER.matcher(source).matches()) {
            int index;
            boolean isNegative = source.charAt(0) == '-';
            int length = source.length();
            String number = isNegative ? source.substring(1, length - 1) : source.substring(0, length - 1);
            String metricPrefix = Character.toString(source.charAt(length - 1));
            Number absoluteNumber = RoundedMetricPrefixFormat.toNumber(number);
            for (index = 0; index < METRIC_PREFIXES.length && !METRIC_PREFIXES[index].equals(metricPrefix); ++index) {
            }
            Integer exponent = 3 * index;
            Double factor = Math.pow(10.0, exponent.intValue());
            factor = factor * (isNegative ? -1.0 : 1.0);
            pos.setIndex(source.length());
            Float result = Float.valueOf(absoluteNumber.floatValue() * (float)factor.longValue());
            return result.longValue();
        }
        return null;
    }

    private static Number toNumber(String number) {
        return NumberUtils.createNumber((String)number);
    }
}

