/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import host.anzo.commons.model.RouletteRandomEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rnd {
    public static double get() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static int get(int n) {
        if (n == 0) {
            return 0;
        }
        int sign = n > 0 ? 1 : -1;
        return sign * ThreadLocalRandom.current().nextInt(Math.abs(n));
    }

    public static long get(long n) {
        if (n == 0L) {
            return 0L;
        }
        int sign = n > 0L ? 1 : -1;
        return (long)sign * (long)(ThreadLocalRandom.current().nextDouble() * (double)n);
    }

    public static double get(double n) {
        if (n == 0.0) {
            return 0.0;
        }
        int sign = n > 0.0 ? 1 : -1;
        return (double)sign * (ThreadLocalRandom.current().nextDouble() * n);
    }

    public static float get(float n) {
        if (n == 0.0f) {
            return 0.0f;
        }
        int sign = n > 0.0f ? 1 : -1;
        return (float)sign * (ThreadLocalRandom.current().nextFloat() * n);
    }

    public static int get(int min, int max) {
        return min + Rnd.get(max - min + 1);
    }

    public static long get(long min, long max) {
        return min + Rnd.get(max - min + 1L);
    }

    public static float get(float min, float max) {
        return min + Rnd.get(max - min);
    }

    public static double get(double min, double max) {
        return min + Rnd.get(max - min);
    }

    public static int nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static double nextDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static double nextGaussian() {
        return ThreadLocalRandom.current().nextGaussian();
    }

    public static boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static byte[] nextBytes(byte[] bytes) {
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }

    public static boolean getChance(int chance) {
        return chance >= 1 && (chance > 99 || ThreadLocalRandom.current().nextInt(99) + 1 <= chance);
    }

    public static boolean getChance(double chance) {
        return ThreadLocalRandom.current().nextDouble() * 100.0 <= chance;
    }

    public static boolean getChance(int chance, int divider) {
        return Rnd.getChance((double)chance / (double)divider);
    }

    public static <E> E get(E @NotNull [] list) {
        return list[Rnd.get(list.length)];
    }

    public static int get(int @NotNull [] list) {
        return list[Rnd.get(list.length)];
    }

    @Nullable
    public static <E> E get(@NotNull List<E> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(Rnd.get(list.size()));
    }

    public static <E> E get(@NotNull List<E> list, E defaultValue) {
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.get(Rnd.get(list.size()));
    }

    @Nullable
    public static <E> E get(@NotNull Collection<E> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return (E)collection.toArray()[Rnd.get(collection.size())];
    }

    public static <E extends Enum<E>> E get(@NotNull Class<E> clazz) {
        return (E)((Enum[])clazz.getEnumConstants())[Rnd.get(((Enum[])clazz.getEnumConstants()).length)];
    }

    @NotNull
    public static List<RouletteRandomEntry> getRouletteEntries(List<RouletteRandomEntry> input, int count) {
        ArrayList<RouletteRandomEntry> selectedMainTemplates = new ArrayList<RouletteRandomEntry>();
        ArrayList<RouletteRandomEntry> copyItems = new ArrayList<RouletteRandomEntry>(input);
        for (int i = 0; i < count; ++i) {
            int totalChance = copyItems.stream().mapToInt(RouletteRandomEntry::chance).sum();
            int randomValue = Rnd.get(totalChance);
            int accumulatedChance = 0;
            int selectedIndex = -1;
            for (int j = 0; j < copyItems.size(); ++j) {
                if (randomValue >= (accumulatedChance += ((RouletteRandomEntry)copyItems.get(j)).chance())) continue;
                selectedIndex = j;
                break;
            }
            if (selectedIndex == -1) continue;
            selectedMainTemplates.add((RouletteRandomEntry)copyItems.remove(selectedIndex));
        }
        return selectedMainTemplates;
    }

    @Nullable
    public static RouletteRandomEntry getRouletteEntry(List<RouletteRandomEntry> input) {
        return Rnd.getRouletteEntries(input, 1).stream().findFirst().orElse(null);
    }

    public static double getRandomWithTick(double min, double max, long serverTick, long randomSeed) {
        long randomizeSeed = (serverTick + randomSeed) * 19088743L * -1985229329L * 19088743L * -1985229329L * 82L * 97L * 110L * 100L * 111L * 109L * (randomSeed + -1985229329L) & 0xFFFFFFFFL;
        long FIXED_RANDOM = randomizeSeed + (randomizeSeed % 11L - randomizeSeed % 10L + randomizeSeed % 9L - randomizeSeed % 8L + randomizeSeed % 7L - randomizeSeed % 6L + randomizeSeed % 5L - randomizeSeed % 4L + randomizeSeed % 3L - randomizeSeed % 2L + randomizeSeed) & 0xFFFFFFFFL;
        return (double)((float)(FIXED_RANDOM % 10000L) / 9999.0f) * (max - min) + min;
    }

    @NotNull
    public static String getString(int length) {
        return RandomStringUtils.randomAlphabetic((int)length);
    }

    @NotNull
    public static String getStringHex(int length) {
        return RandomStringUtils.random((int)length, (String)"0123456789abcdef");
    }
}

