/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.startup;

import host.anzo.commons.utils.ClassUtils;
import host.anzo.core.startup.Scheduled;
import host.anzo.core.startup.ScheduledService;
import host.anzo.core.startup.StartupMethodInfo;
import host.anzo.core.startup.StartupRun;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class StartModule<SL extends Enum<SL>> {
    private final List<StartModule<SL>> dependency = new ArrayList<StartModule<SL>>(0);
    private final Map<String, List<StartupMethodInfo>> beforeMethods = new HashMap<String, List<StartupMethodInfo>>();
    private final Map<String, List<StartupMethodInfo>> afterMethods = new HashMap<String, List<StartupMethodInfo>>();
    private final SL startLevel;
    private final Class<?> clazz;
    private Object instance;

    public StartModule(SL startLevel, @NotNull Class<?> clazz) {
        this.startLevel = startLevel;
        this.clazz = clazz;
        for (Method method : Stream.concat(Arrays.stream(clazz.getDeclaredMethods()), Arrays.stream(clazz.getSuperclass().getDeclaredMethods())).toList()) {
            if (!method.isAnnotationPresent(StartupRun.class)) continue;
            StartupRun startupRun = method.getAnnotation(StartupRun.class);
            if (!StringUtils.isEmpty((CharSequence)startupRun.after())) {
                this.afterMethods.computeIfAbsent(startupRun.after(), k -> new ArrayList()).add(new StartupMethodInfo(clazz, method, startupRun.isAsync()));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)startupRun.before())) continue;
            this.beforeMethods.computeIfAbsent(startupRun.before(), k -> new ArrayList()).add(new StartupMethodInfo(clazz, method, startupRun.isAsync()));
        }
    }

    public void addDependency(StartModule<SL> module) {
        this.dependency.add(module);
    }

    public void init() {
        if (this.instance != null) {
            return;
        }
        for (StartModule<SL> depend : this.dependency) {
            depend.init();
        }
        this.instance = ClassUtils.singletonInstance(this.clazz);
        Collection<Method> scheduledMethods = ClassUtils.getMethodsAnnotatedWith(this.clazz, Scheduled.class);
        for (Method scheduledMethod : scheduledMethods) {
            if (!Modifier.isPublic(scheduledMethod.getModifiers())) {
                throw new IllegalStateException("Method annotated with @Scheduled must be public!");
            }
            ScheduledService.getInstance().addScheduledMethod(this.clazz, scheduledMethod);
        }
    }

    public String toString() {
        return this.clazz.getSimpleName();
    }

    @Generated
    public Map<String, List<StartupMethodInfo>> getBeforeMethods() {
        return this.beforeMethods;
    }

    @Generated
    public Map<String, List<StartupMethodInfo>> getAfterMethods() {
        return this.afterMethods;
    }

    @Generated
    public SL getStartLevel() {
        return this.startLevel;
    }

    @Generated
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Generated
    public Object getInstance() {
        return this.instance;
    }
}

