/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import de.mxro.metrics.jre.Metrics;
import delight.async.properties.PropertyNode;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.emergency.metric.IMetric;
import host.anzo.commons.emergency.metric.MetricGroupType;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.core.config.EmergencyConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.text.TextStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class ForkJoinPoolService
implements IMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForkJoinPoolService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final PropertyNode packetSubmitsMetric = Metrics.create();
    private static final PropertyNode foreachMetric = Metrics.create();
    private final ForkJoinPool packetPool = new ForkJoinPool(Math.max(1, Runtime.getRuntime().availableProcessors()), pool -> {
        ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        worker.setName("PacketPool-" + worker.getPoolIndex());
        return worker;
    }, null, true);
    private final ForkJoinPool foreachPool = new ForkJoinPool(Math.max(1, Runtime.getRuntime().availableProcessors()), pool -> {
        ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        worker.setName("ForeachPool-" + worker.getPoolIndex());
        return worker;
    }, null, true);

    protected ForkJoinPoolService() {
    }

    public void sendPackets(String name, Runnable runnable) {
        if (EmergencyConfig.ENABLE_METRICS) {
            packetSubmitsMetric.record(Metrics.happened((String)name));
        }
        try {
            ((ForkJoinTask)this.packetPool.submit(runnable)).get();
        }
        catch (Exception e) {
            log.error("Error while sendPackets name={}", (Object)name, (Object)e);
        }
    }

    public void forEach(String name, Runnable runnable) {
        if (EmergencyConfig.ENABLE_METRICS) {
            foreachMetric.record(Metrics.happened((String)name));
        }
        try {
            ((ForkJoinTask)this.foreachPool.submit(runnable)).get();
        }
        catch (Exception e) {
            log.error("Error while forEach name={}", (Object)name, (Object)e);
        }
    }

    public String getStats() {
        TextStringBuilder builder = new TextStringBuilder();
        builder.appendln(" | -------");
        builder.appendln(" + PacketPool:");
        builder.appendln(" |- ActiveThreads:       " + this.packetPool.getActiveThreadCount());
        builder.appendln(" |- PoolSize:            " + this.packetPool.getPoolSize());
        builder.appendln(" |- QueuedTasks:         " + this.packetPool.getQueuedTaskCount());
        builder.appendln(" |- RunningThreadCount:  " + this.packetPool.getRunningThreadCount());
        builder.appendln(" | -------");
        builder.appendln(" + ForeachPool:");
        builder.appendln(" |- ActiveThreads:       " + this.foreachPool.getActiveThreadCount());
        builder.appendln(" |- PoolSize:            " + this.foreachPool.getPoolSize());
        builder.appendln(" |- QueuedTasks:         " + this.foreachPool.getQueuedTaskCount());
        builder.appendln(" |- RunningThreadCount:  " + this.foreachPool.getRunningThreadCount());
        builder.appendln(" | -------");
        return builder.toString();
    }

    @Override
    public List<MetricResult> getMetric() {
        ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
        MetricResult packetSubmitsResult = new MetricResult();
        packetSubmitsResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        packetSubmitsResult.setName("PacketsSubmit");
        packetSubmitsResult.setData((String)packetSubmitsMetric.render().get());
        metricResults.add(packetSubmitsResult);
        MetricResult foreachResult = new MetricResult();
        foreachResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        foreachResult.setName("Foreach");
        foreachResult.setData((String)foreachMetric.render().get());
        metricResults.add(foreachResult);
        return metricResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ForkJoinPoolService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ForkJoinPoolService actualValue = new ForkJoinPoolService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ForkJoinPoolService)($value == instance ? null : $value);
    }
}

