package host.anzo.core.webserver.engine;

import host.anzo.core.config.WebServerConfig;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import org.jetbrains.annotations.NotNull;
import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.context.Context;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import spark.*;

import java.util.Locale;
import java.util.Map;

/**
 * @author ANZO
 * @since 18.08.2016
 */
public class ThymeleafTemplateEngine extends TemplateEngine {
	private final org.thymeleaf.TemplateEngine thymeleaf;

	public ThymeleafTemplateEngine() {
		final FileTemplateResolver templateResolver = new FileTemplateResolver();
		templateResolver.setTemplateMode(TemplateMode.HTML);
		templateResolver.setPrefix(WebServerConfig.DATA_PATH);
		templateResolver.setSuffix(".html");
		templateResolver.setCacheTTLMs(3600000L);
		templateResolver.setCacheable(!WebServerConfig.DEBUG);

		thymeleaf = new org.thymeleaf.TemplateEngine();
		thymeleaf.setTemplateResolver(templateResolver);
		thymeleaf.addDialect(new LayoutDialect());
	}

	@Override
	public String render(@NotNull ModelAndView modelAndView) {
		final AbstractContext ctx = new Context(Locale.getDefault());
		if (modelAndView.getModel() instanceof Map<?, ?>) {
			if (WebServerConfig.DEBUG) {
				for (Object key : ((Map<Object, Object>) modelAndView.getModel()).keySet()) {
					if (!(key instanceof String)) {
						throw new IllegalArgumentException("All keys of the model must be Strings");
					}
				}
			}
			ctx.setVariables((Map<String, Object>) modelAndView.getModel());
			return thymeleaf.process(modelAndView.getViewName(), ctx);
		}
		else {
			ctx.setVariable("model", modelAndView.getModel());
			return thymeleaf.process(modelAndView.getViewName(), ctx);
		}
	}
}