package host.anzo.commons.collection;

import java.util.*;

/**
 * @author ANZO
 * @since 6/22/2022
 */
public class MapSplitter<K, V> {
    private TreeMap<K, V> map;
    private List<K> keys;
    private int splitCount;
    private int currentIndex = 0;

    public MapSplitter(Map<K, V> map, int splitCount) {
        if (map != null) {
            this.map = new TreeMap<>(map);
            this.keys = new ArrayList<>(this.map.keySet());
            this.splitCount = splitCount;
        }
    }
    public MapSplitter(Map<K, V> map, Comparator<? super K> comparator, int splitCount) {
        if (map != null) {
            this.map = new TreeMap<>(comparator);
            this.map.putAll(map);
            this.keys = new ArrayList<>(this.map.keySet());
            this.splitCount = splitCount;
        }
    }

    public Map<K, V> getNext(int splitCount) {
        this.splitCount = splitCount;
        return getNext();
    }

    public Map<K, V> getNext() {
        final Map<K, V> chunk;
        if (currentIndex + splitCount < map.size()) {
            chunk = map.subMap(keys.get(currentIndex), keys.get(currentIndex + splitCount));
        }
        else {
            chunk = map.tailMap(keys.get(currentIndex));
        }
        currentIndex += splitCount;
        return chunk;
    }

    public int size() {
        return map.size();
    }

    public boolean isFirst() {
        return currentIndex <= splitCount;
    }

    public boolean isLast() {
        return currentIndex == map.size();
    }

    public boolean hasNext() {
        return currentIndex < map.size();
    }
}