package host.anzo.commons.datetime.dailytick;

import host.anzo.commons.utils.DateTimeUtils;
import lombok.Getter;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.TimeUnit;

/**
 * @author ANZO
 */
public @Getter enum EDailyTickType {
    _0_AM(0),
    _6_AM(6),
    EVERY_HOUR(-1);

    private final int hour;

    EDailyTickType(int hour) {
        this.hour = hour;
    }

    public long getTimeToNextTick() {
        if (this == EDailyTickType.EVERY_HOUR) {
            return DateTimeUtils.getNextHourTime(System.currentTimeMillis()) - System.currentTimeMillis();
        }
        return DateTimeUtils.getNextHourTime(System.currentTimeMillis(), getHour()) - System.currentTimeMillis();
    }

    public long getTickPeriod() {
        if (this == EDailyTickType.EVERY_HOUR) {
            return TimeUnit.HOURS.toMillis(1);
        }
        return TimeUnit.DAYS.toMillis(1);
    }

    public static @Nullable EDailyTickType valueOfHour(int hour) {
        for (EDailyTickType dailyTickType : values()) {
            if (dailyTickType.getHour() == hour) {
                return dailyTickType;
            }
        }
        return null;
    }
}