package host.anzo.commons.utils;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import org.jetbrains.annotations.Nullable;

import javax.management.MBeanServer;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

/**
 * @author ANZO
 * @since 12.02.2017
 */
public class HotSpotUtils {
    private static HotSpotDiagnosticMXBean hotspotDiagnosticBean;

    static {
        synchronized (HotSpotUtils.class) {
            if (hotspotDiagnosticBean == null) {
                hotspotDiagnosticBean = getHotspotDiagnosticBean();
            }
        }
    }

    public static HotSpotDiagnosticMXBean getBean() {
        return hotspotDiagnosticBean;
    }

    public static VMOption getVMOption(String optionName) {
        return hotspotDiagnosticBean.getVMOption(optionName);
    }

    public static long getDirectBufferFreeMemory() {
        final BufferPoolMXBean bufferPool = getByteBufferPool(true);
        if (bufferPool != null) {
            return Long.parseLong(getVMOption("MaxDirectMemorySize").getValue()) - bufferPool.getMemoryUsed();
        }
        return -1;
    }

    public static @Nullable BufferPoolMXBean getByteBufferPool(boolean isDirect) {
        final List<BufferPoolMXBean> pools = getByteBufferPools();
        for (BufferPoolMXBean pool : pools) {
            if (isDirect && pool.getName().equals("direct")) {
                return pool;
            }
            return pool;
        }
        return null;
    }

    public static List<BufferPoolMXBean> getByteBufferPools() {
        return ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    }

    private static HotSpotDiagnosticMXBean getHotspotDiagnosticBean() {
        try {
            final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        } catch (RuntimeException re) {
            throw re;
        } catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }
}
