package host.anzo.core.startup;

import lombok.extern.slf4j.Slf4j;

import javax.annotation.Nullable;
import java.util.*;

/**
 * @author ANZO
 */
@Slf4j
public class StartupInstance<SL extends Enum<SL>> {
	private final HashMap<SL, List<StartModule<SL>>> startTable = new HashMap<>();

	void put(SL level, StartModule<SL> module) {
		List<StartModule<SL>> invokes = startTable.computeIfAbsent(level, k -> new ArrayList<>());
		invokes.add(module);
	}

	protected Collection<Map.Entry<SL,List<StartModule<SL>>>> getAll() {
		return startTable.entrySet();
	}

	protected @Nullable List<StartModule<SL>> get(SL level) {
		return startTable.getOrDefault(level, null);
	}
	
	void runLevel(SL level) {
		final List<StartModule<SL>> list = startTable.get(level);
		if(list == null) {
			return;
		}

		list.forEach(StartModule::init);
	}

	boolean levelExists(SL level) {
		return startTable.get(level) != null && !startTable.get(level).isEmpty();
	}
}